/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.offline;

import java.io.File;

import java.util.Map;
import java.util.HashMap;

import com.sun.appserv.management.base.AMXDebug;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;

import com.sun.enterprise.config.impl.ConfigContextImpl;


/**
 */
public final class ConfigDelegateFactory
{
    private ConfigContext   mConfigContext;
    private final File      mDomainXML;
    
    private static Map<File,ConfigDelegateFactory>   mFactories;
    
        private
    ConfigDelegateFactory(final File domainXML )
        throws ConfigException
    {
        mDomainXML  = domainXML;
        mConfigContext  = createConfigContext( mDomainXML );
    }
    
        private void
    debug( final Object o )
    {
        AMXDebug.getInstance().getOutput( "ConfigDelegateFactory" ).println( o );
    }
    
        public static synchronized ConfigDelegateFactory
    getInstance( final File domainXML )
        throws ConfigException
    {
        if ( mFactories == null )
        {
            mFactories  = new HashMap<File,ConfigDelegateFactory>();
        }

        ConfigDelegateFactory   instance    = mFactories.get( domainXML );
	    if ( instance == null )
	    {
	        instance    = new ConfigDelegateFactory( domainXML );
	        mFactories.put( domainXML, instance );
	    }
	    
	    return instance;
    }
    
        synchronized ConfigDelegate
    createConfigDelegate( final ConfigBean configBean )
        throws ConfigException
    {
        if ( getConfigContext() != configBean.getConfigContext() )
        {
            throw new IllegalArgumentException( "ConfigBean " +
                configBean.getXPath() + " has mismatched ConfigContext" );
        }

        return new ConfigDelegate( getConfigContext(), configBean );
    }
               
        private ConfigContext
    createConfigContext( final File domainXML ) 
        throws ConfigException
    {
        setPreEnvironment();
        
        final ConfigContext ctx =
            ConfigFactory.createConfigContext( domainXML.toString(),
                true, true, true );
        
        setPostEnvironment( ctx );
        
        return ctx;
    }
    
        public ConfigContext
    getConfigContext()
    {
        return mConfigContext;
    }


        private void
    setPreEnvironment()
    {
        System.setProperty(
              "com.sun.enterprise.config.config_environment_factory_class", 
              "com.sun.enterprise.config.serverbeans.AppserverConfigEnvironmentFactory"
         );
    }

        private void
    setPostEnvironment( final ConfigContext ctx)
    {
        try
        {
            ((ConfigContextImpl)ctx).setXPathInAllBeans();
        }
        catch(ConfigException e)
        {
            throw new RuntimeException( e );
        }
    }
}
























