/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/OldTypeToJ2EETypeMapper.java,v 1.2 2005/12/25 03:40:50 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2005/12/25 03:40:50 $
 */

package com.sun.enterprise.management.support;

import javax.management.ObjectName;

/**
	Map types to/from an "old" and "new" type.
 */
public interface OldTypeToJ2EETypeMapper
{
	/**
		Return a new j2eeType based on an old ObjectName.  The ObjectName
		is required because the old type alone may not be sufficient; in particular
		the name property may be required.
		
		@param objectName
	 */
	public String	oldObjectNameToJ2EEType( final ObjectName objectName );
	
	/**
		Return a new j2eeType based on an old ObjectName and a particular type,
		which may be the j2eeType of the ObjectName or one of its other property keys.
		The ObjectName is required because the old type alone may not be sufficient;
		for example the name property may be required.
		
		@param oldType
		@param objectName
	 */
	public String	oldTypeToJ2EEType( final String oldType, final ObjectName objectName );
	
	/**
		@param j2eeType
	 */
	public String	j2eeTypeToOldType( final String j2eeType );
}








