/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/base/AMXDebugTest.java,v 1.4 2005/12/25 03:41:22 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:22 $
 */
package com.sun.enterprise.management.base;

import java.io.File;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.util.misc.Output;



import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.enterprise.management.Capabilities;

/**
 */
public final class AMXDebugTest extends junit.framework.TestCase
{
		public
	AMXDebugTest()
	{
	    getAMXDebug().setDefaultDebug( true );
	    getAMXDebug().setAll( true );
	}
	
        private String
    getID( final String uniquifier )
    {
        return this.getClass().getName() + "." + uniquifier;
    }
    
        private Output
    getOutput( final String id )
    {
        return getAMXDebug().getOutput( id );
    }
    
        private AMXDebug
    getAMXDebug()
    {
        return AMXDebug.getInstance();
    }
       
	    public synchronized void
	testCreateFile()
	{
	    // multiple iterations require that we choose a new file each time
	    final String    id      = getID( "testCreateFile" + System.currentTimeMillis() );
	    final Output    output  = getOutput( id );
	    
	    final File  outputFile  = getAMXDebug().getOutputFile( id );
	    outputFile.delete();
	    assert( ! outputFile.exists() );
	    
	    output.printDebug( "test" );
	    assert( outputFile.exists() );
	}
       
	    public synchronized void
	testToggleDebug()
	{
	    final String    id      = getID( "testToggleDebug" );
	    final Output    output  = getOutput( id );
	    
	    getAMXDebug().setDebug( id, false );
	    assert( ! getAMXDebug().getDebug( id ) );
	    getAMXDebug().setDebug( id, true );
	    assert( getAMXDebug().getDebug( id ) );
	}
	
	    public synchronized void
	testReset()
	{
	    final String    id      = getID( "testReset" );
	    final Output    output  = getOutput( id );
	    
	    getAMXDebug().reset( id );
	    final File  outputFile  = getAMXDebug().getOutputFile( id );
	    outputFile.delete();
	    assert( ! outputFile.exists() );
	    output.printDebug( "test" );
	    assert( outputFile.exists() );
	    
	    // make sure we can call it repeatedly
	    getAMXDebug().reset( id );
	    getAMXDebug().reset( id );
	    getAMXDebug().reset( id );
	}
	
	
	    public synchronized void
	testPrint()
	{
	    final String    id      = getID( "testPrint" );
	    final Output    output  = getOutput( id );
	    
	    output.printDebug( "printDebug" );
	    output.printError( "printError" );
	    output.println( "println" );
	    output.print( "print" );output.print( "..." );output.print( "END" );
	}
	
	
	    public synchronized void
	testClose()
	{
	    final String    id      = getID( "testClose" );
	    final Output    output  = getOutput( id );
	    final File      outputFile  = getAMXDebug().getOutputFile( id );
	    
	    output.println( "hello" );
	    assert( outputFile.exists() );
	    
	    output.close();
	    outputFile.delete();
	    assert( !outputFile.exists() );
	    
	    output.println( "hello" );
	    assert( outputFile.exists() );
	}
	
	    public synchronized void
	testToggleDefaultDebug()
	{
	    final String    id      = getID( "testToggleDefaultDebug" );
	    final Output    output  = getOutput( id );
	    
	    getAMXDebug().setDefaultDebug( false );
	    assert( ! getAMXDebug().getDefaultDebug() );
	    
	    getAMXDebug().setDefaultDebug( true );
	    assert( getAMXDebug().getDefaultDebug() );
	}
	
	
	    public synchronized void
	testSetAll()
	{
	    final String    id      = getID( "testSetAll" );
	    final Output    output  = getOutput( id );
	    
	    getAMXDebug().setAll( false );
	    getAMXDebug().setAll( false );
	    getAMXDebug().setAll( true );
	    getAMXDebug().setAll( true );
	    getAMXDebug().setAll( false );
	    getAMXDebug().setAll( true );
	    getAMXDebug().setAll( true );
	}
	
	
	    public synchronized void
	testMark()
	{
	    final String    id      = getID( "testMark" );
	    final Output    output  = getOutput( id );
	    
	    getAMXDebug().mark( id );
	    getAMXDebug().mark( id, null );
	    getAMXDebug().mark( id, "marker 1" );
	    getAMXDebug().mark( id, "marker 2" );
	    getAMXDebug().mark( output, null );
	    getAMXDebug().mark( output, "marker 3" );
	}
}

