/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.base;

import java.util.Set;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.AttributeChangeNotification;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.NotificationServiceMgr;
import com.sun.appserv.management.base.NotificationService;
import com.sun.appserv.management.helper.NotificationServiceHelper;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.client.ProxyFactory;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class NotificationServiceTest extends AMXTestBase
{
		public
	NotificationServiceTest( )
	{
	}
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( true );
	}

		public NotificationService
	create()
	{
		final NotificationServiceMgr	proxy	= getNotificationServiceMgr();
		
		return( proxy.createNotificationService( "test", 512 ) );
	}

		public void
	testCreate()
		throws Exception
	{
		final NotificationService	proxy	= create();
		
		removeNotificationService( proxy );
	}

		public void
	testGetFromEmpty()
		throws Exception
	{
		final NotificationService	proxy	= create();
		
		assert( proxy.getListeneeSet().size() == 0 );
		final Object	id	= proxy.createBuffer( 10, null);
		final Map<String,Object>	result	= proxy.getBufferNotifications( id, 0 );
		final Notification[]	notifs	= (Notification[])result.get( proxy.NOTIFICATIONS_KEY );
		assertEquals( 0, notifs.length );
	}
	
		private  void
	removeNotificationService( final NotificationService service )
		throws InstanceNotFoundException
	{
		getNotificationServiceMgr().removeNotificationService( service.getName() );
	}


	private static final class MyListener implements NotificationListener
	{
		private final List<Notification>	mReceived;
		
		public MyListener()
		{
			mReceived	= Collections.synchronizedList( new ArrayList<Notification>() );
		}
		
			public void
		handleNotification( final Notification notif, final Object handback )
		{
			mReceived.add( notif );
		}
		
			public int
		getCount()
		{
			return( mReceived.size() );
		}
	}
	
		private static void
	sleep( int duration )
	{
		try
		{
			Thread.sleep( duration );
		}
		catch( InterruptedException e )
		{
		}
	}
	
		public void
	testListen()
		throws Exception
	{
		final NotificationService	proxy	= create();
	
		final QueryMgr	queryMgr	= getQueryMgr();
		final ObjectName	objectName	= Util.getObjectName( queryMgr );
		
		final Object	id	= proxy.createBuffer( 10, null);
		final NotificationServiceHelper	helper	= new NotificationServiceHelper( proxy, id);
		proxy.listenTo( objectName, null );
		assert( proxy.getListeneeSet().size() == 1 );
		assert( Util.getObjectName( (Util.asAMX(proxy.getListeneeSet().iterator().next())) ).equals( objectName ) );
		
		final MyListener	myListener	= new MyListener();
		proxy.addNotificationListener( myListener, null, null );
		 
		final Level	saveLevel = queryMgr.getMBeanLogLevel();
		queryMgr.setMBeanLogLevel( Level.INFO );
		queryMgr.setMBeanLogLevel( saveLevel );
		
		// delivery may be asynchronous; wait until done
		while ( myListener.getCount() < 2 )
		{
			sleep( 20 );
		}
		assert( myListener.getCount() == 2 );
		
		Notification[]	notifs	= helper.getNotifications();
		
		assertEquals( 2, notifs.length );
		assert( notifs[ 0 ].getType().equals( AttributeChangeNotification.ATTRIBUTE_CHANGE ) );
		assert( notifs[ 1 ].getType().equals( AttributeChangeNotification.ATTRIBUTE_CHANGE ) );
		notifs	= helper.getNotifications();
		assert( notifs.length == 0 );
		
		
		proxy.dontListenTo( objectName );
		assert( proxy.getListeneeSet().size() == 0 );
		
		removeNotificationService( proxy );
	}

}


