/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.CustomResourceConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class CustomResourceConfigTest extends ResourceConfigTestBase
{
	static final Map<String,String>	OPTIONAL	= new HashMap<String,String>();
	
	// doesn't exist, just give a syntactically valid name
	static private final String RES_TYPE   = "CustomResourceConfigTest.Dummy";
	static private final String FACTORY_CLASS   =
	    "com.sun.enterprise.management.config.CustomResourceConfigTestDummy";
	
		public
	CustomResourceConfigTest ()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
	    public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "CustomResourceConfig" );
    }
    
    
        public static CustomResourceConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    CustomResourceConfig   result  =
	        domainConfig.getCustomResourceConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( domainConfig,
	            getDefaultInstanceName(), RES_TYPE, FACTORY_CLASS, null );
	    }
	    
	    return result;
	}
	
	    public static CustomResourceConfig
	createInstance(
	    final DomainConfig domainConfig,
	    final String    name,
	    final String    resType,
	    final String    factoryClass,
	    final Map<String,String> optional )
	{
	    final CustomResourceConfig  config  =
	        domainConfig.createCustomResourceConfig( name, resType, factoryClass, optional );
		
		return config;
	}
	
	
		protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.CUSTOM_RESOURCE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeCustomResourceConfig( name );
	}
	
    	protected String
	getProgenyTestName()
	{
		return( "CustomResourceConfigTest" );
	}
    
		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options ) 
	{
	    final CustomResourceConfig   config =
	        createInstance( getDomainConfig(), name, RES_TYPE, FACTORY_CLASS, options );
	    
		addReference( config );
		
		return config;
	}
}


