/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.JNDIResourceConfig;

import com.sun.appserv.management.helper.RefHelper;

/**
 */
public final class JNDIResourceConfigTest extends ResourceConfigTestBase
{
    private static final String JNDI_RESOURCE_JNDI_LOOKUP_NAME = "jndi/jndiTest";
    private static final String JNDI_RESOURCE_RES_TYPE = "javax.sql.DataSource";
    private static final String JNDI_RESOURCE_FACTORY_CLASS = "com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerFactoryImpl";
    private static final Map<String,String> OPTIONAL    = null;

		public
	JNDIResourceConfigTest ()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
	     public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "JNDIResourceConfig" );
    }
    
         public static JNDIResourceConfig
	ensureDefaultInstance( final DomainConfig dc )
	{
	    JNDIResourceConfig   result  =
	        dc.getJNDIResourceConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( dc,
	            getDefaultInstanceName(),
	            JNDI_RESOURCE_JNDI_LOOKUP_NAME,
                JNDI_RESOURCE_RES_TYPE,
                JNDI_RESOURCE_FACTORY_CLASS,
	            OPTIONAL );
	    }
	    
	    return result;
	}
	
	    public static JNDIResourceConfig
	createInstance(
	    final DomainConfig  dc,
        final String    name,
        final String    jndiLookupName, 
        final String    resType,
        final String    factoryClass,
        final Map<String,String> optional)
	{
	    return dc.createJNDIResourceConfig(
	            name, jndiLookupName, resType, factoryClass , optional );
	}
	
	
		protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.JNDI_RESOURCE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
	    final JNDIResourceConfig item   =
	        getDomainConfig().getJNDIResourceConfigMap().get( name );
	    
		getDomainConfig().removeJNDIResourceConfig( name );
	}

		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options) 
	{
		final JNDIResourceConfig	config	= getDomainConfig().createJNDIResourceConfig( name,
				JNDI_RESOURCE_JNDI_LOOKUP_NAME, 
				JNDI_RESOURCE_RES_TYPE,
				JNDI_RESOURCE_FACTORY_CLASS,
				options );
		
		addReference( config );
		
		return( config );
	}
}


