/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/ResourceAdapterConfigTest.java,v 1.4 2005/12/25 03:41:41 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:41 $
 */
package com.sun.enterprise.management.config;


import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ResourceAdapterConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class ResourceAdapterConfigTest extends AMXTestBase
{
		public
	ResourceAdapterConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "ResourceAdapterConfig" );
    }
    
	    public static ResourceAdapterConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    ResourceAdapterConfig   result  =
	        domainConfig.getResourceAdapterConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( domainConfig, getDefaultInstanceName() );
	    }
	    
	    return result;
	}
	
	    public static ResourceAdapterConfig
	createInstance(
	    final DomainConfig  domainConfig,
	    final String        name )
	{
	    final ResourceAdapterConfig rac =
	        domainConfig.createResourceAdapterConfig( name, null );
	    
	    return rac;
	}
	
	    private void
	testGetters( final ResourceAdapterConfig resAdapterConfig )
	{
	    resAdapterConfig.getResourceAdapterName();
	    resAdapterConfig.getThreadPoolIDs();
	}
	
	    public void
	testCreateRemove()
	{
	    if ( checkNotOffline( "testCreateSSL" ) )
	    {
            final ResourceAdapterConfig resAdapterConfig    =
                createInstance( getDomainConfig(),
                    "ResourceAdapterConfigTest.testCreateRemove" );

            try
            {
                testGetters( resAdapterConfig );
            }
            finally
            {
                getDomainConfig().removeResourceAdapterConfig( resAdapterConfig.getName() );
            }
	    }
	}
	
}



























