/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.SecurityMapConfig;
import com.sun.appserv.management.config.BackendPrincipalConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.ResourceAdapterConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.appserv.management.util.misc.GSetUtil;


/**
 */
public final class SecurityMapConfigTest extends AMXTestBase
{
		public
	SecurityMapConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
	
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "SecurityMapConfig" );
    }
    
	private static final String DEFAULT_BACKEND_PRINCIPAL   = "SecurityMapConfigTest.default";
	private static final String DEFAULT_BACKEND_PASSWORD   = "changeme";
	private static final String[] DEFAULT_PRINCIPALS         =
	    new String[] { "SecurityMapConfigTest.principal1" };
	private static final String[] DEFAULT_USERGROUPS         = new String[0];
	
        public static SecurityMapConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    final ConnectorConnectionPoolConfig ccpc    =
	        ConnectorConnectionPoolConfigTest.ensureDefaultInstance( domainConfig );
	    
	    SecurityMapConfig   result  =
	        ccpc.getSecurityMapConfigMap().get( getDefaultInstanceName() );
	    if ( result == null )
	    {
	        result  = createInstance( ccpc,
	            getDefaultInstanceName(),
	            DEFAULT_BACKEND_PRINCIPAL,
	            DEFAULT_BACKEND_PASSWORD,
	            DEFAULT_PRINCIPALS,
	            DEFAULT_USERGROUPS );
	    }
	    
	    return result;
	}
	
	
	    private void
	testGetters( final SecurityMapConfig smc )
	{
	    final String[]  principalNames  = smc.getPrincipalNames();
	    final String[]  userGroupNames  = smc.getUserGroupNames();
	    
	    assert( principalNames != null || userGroupNames != null ) : "both principals and usergroups are null";
	    
	    final BackendPrincipalConfig    bpc = smc.getBackendPrincipalConfig();
	    assert( bpc != null );
	    final String    s   = bpc.getUserName();
	    bpc.setUserName( s );
	    final String    password    = bpc.getPassword();
	    bpc.setPassword( password );
	}
	
	
	    public static SecurityMapConfig
	createInstance(
	    final ConnectorConnectionPoolConfig ccpc,
	    final String    name,
	    final String    backendPrincipalUsername,
	    final String    backendPrincipalPassword,
	    final String[]  principals,
	    final String[]  userGroups )
	{
        final SecurityMapConfig  smc =
            ccpc.createSecurityMapConfig( name,
                backendPrincipalUsername, backendPrincipalPassword,
                principals, userGroups);
        
        return smc;
	}
	
    private static final String CONNECTOR_DEF_NAME = "javax.resource.cci.ConnectionFactory";
    
	    public void
	testCreateRemove()
	{
	    if ( ! checkNotOffline( "testDeleteLBConfig" ) )
	    {
	        return;
	    }
	    
	    final String TEST_NAME  = "SecurityMapConfigTest.testCreateRemove";
	    final ResourceAdapterConfig rac = ResourceAdapterConfigTest.createInstance(
	        getDomainConfig(), TEST_NAME );
	    
	    try
	    {
    	    final ConnectorConnectionPoolConfig ccpc    =
    	        ConnectorConnectionPoolConfigTest.createInstance( getDomainConfig(),
    	            TEST_NAME,
    	            CONNECTOR_DEF_NAME,
    	            rac.getName(), null );
    	    
    	    try
    	    {
    	        final String smcName    = "SecurityMapConfigTest.testCreateRemove";
    	        final String[]  principals  = new String[] { "SecurityMapConfigTest.testCreateRemove" };
    	        final String[]  userGroups  = new String[ 0 ];
    	        final SecurityMapConfig  smc = createInstance(
    	            ccpc,
    	            smcName,
    	            DEFAULT_BACKEND_PRINCIPAL,
    	            DEFAULT_BACKEND_PASSWORD,
    	            principals,
    	            null );
    	        try
    	        {
    	            assert( smcName.equals( smc.getName() ) );
    	            assert( smc == ccpc.getSecurityMapConfigMap().get( smc.getName() ) );
    	            testGetters( smc );
    	            
    	            final Set<String> principalsBefore  = GSetUtil.newSet( smc.getPrincipalNames() );
    	            final String    PRINCIPAL1  = "testCreateRemove.test1";
    	            smc.createPrincipal( PRINCIPAL1 );
    	            
    	            final Set<String> principalsAfter  = GSetUtil.newSet( smc.getPrincipalNames() );
    	            assert( principalsAfter.contains( PRINCIPAL1 ) );
    	            
    	            smc.removePrincipal( PRINCIPAL1 );
    	            assert( principalsBefore.equals( GSetUtil.newSet( smc.getPrincipalNames() ) ) );
    	            
    	        }
    	        finally
    	        {
    	            ccpc.removeSecurityMapConfig( smc.getName() );
    	        }    	        
    	    }
    	    finally
    	    {
    	        getDomainConfig().removeConnectorConnectionPoolConfig( ccpc.getName() );
    	    }
	    }
	    finally
	    {
	        getDomainConfig().removeResourceAdapterConfig( rac.getName() );
	    }
	}
	
}



























