/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/StandaloneServerConfigTest.java,v 1.6 2006/03/09 20:30:55 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:55 $
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;
import java.util.Arrays;

import javax.management.ObjectName;


import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.AppserverConnectionSource;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.NodeAgentConfig;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class StandaloneServerConfigTest extends AMXTestBase
{
		public
	StandaloneServerConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainRoot() );
	    }
	}
	
	    public static String
    getDefaultInstanceName()
    {
        return "server";
    }
	
	/**
	    We want the default instance to be available on both PE and EE
	    so we have no choice but to use the DAS instance.
	 */
        public static StandaloneServerConfig
	ensureDefaultInstance( final DomainRoot domainRoot )
	{
	    final Map<String,StandaloneServerConfig>    servers =
	        domainRoot.getDomainConfig().getStandaloneServerConfigMap();
	    
	    StandaloneServerConfig  server  = servers.get( getDefaultInstanceName() );
	    assert( server != null );
	    
	    return server;
	}
	
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( false );
	}
	
	    public void
	testCreateStandaloneServerConfig()
	    throws Throwable
	{
        final ConfigSetup setup  = new ConfigSetup( getDomainRoot() );
        final int       basePort    = 52700;
        
        final Map<String,NodeAgentConfig> nodeAgentConfigs    = getDomainConfig().getNodeAgentConfigMap();
        
        if ( nodeAgentConfigs.keySet().size() == 0 )
        {
            warning( "testCreateStandaloneServerConfig: No node agents available, skipping test." );
        }
        else
        {
            for( final String nodeAgentName : nodeAgentConfigs.keySet() )
            {
                final String serverName    = nodeAgentName + ".StandaloneServerConfigTestServer";
                final String configName    = serverName + "-config";
                
                setup.removeServer( serverName );
                setup.removeConfig( configName );
                
                final ConfigConfig  config  = setup.createConfig( configName );
                assert( configName.equals( config.getName() ) );
                final Map<String,Object>    attrs   = Util.getExtra( config ).getAllAttributes();
                
                try
                {
                    final StandaloneServerConfig  server =
                        setup.createServer( serverName, basePort, nodeAgentName, config.getName() );
                    
                    setup.removeServer( server.getName() );
                }
                catch( Throwable t )
                {
                    try
                    {
                        setup.removeConfig( config.getName() );
                    }
                    catch( Exception ee )
                    {
                    }
                    throw t;
                }
            }
        }
	}
}



























