/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.io.IOException;
import java.io.Serializable;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import javax.management.ObjectName;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.appserv.management.config.HTTPAccessLogConfig;
import com.sun.appserv.management.config.VirtualServerConfigKeys;

import com.sun.appserv.management.util.misc.MapUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class VirtualServerConfigTest extends ConfigMgrTestBase
{
	static final String HOSTS	= "localhost";
	
		public
	VirtualServerConfigTest ()
	{
	}
	
		protected Container
	getProgenyContainer()
	{
		return getHTTPService();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.VIRTUAL_SERVER_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getHTTPService().removeVirtualServerConfig( name );
	}

		protected final VirtualServerConfig
	create(String name) 
	{
	    return (VirtualServerConfig)createProgeny( name, null );
	}
	
	    private Map<String,String>
	getOptional()
	{
	    final Map<String,String> m	= new HashMap<String,String>();
		m.put( VirtualServerConfigKeys.STATE_KEY, VirtualServerConfigKeys.STATE_DISABLED );
		m.put( VirtualServerConfigKeys.DOC_ROOT_PROPERTY_KEY, "/" );
		m.put( VirtualServerConfigKeys.ACCESS_LOG_PROPERTY_KEY, "/" );
		
		return m;
	}

		protected final AMXConfig
	createProgeny(
	    final String name,
	    final Map<String,String> extra )
	{
		final Map<String,String> allOptions	= MapUtil.newMap( extra, getOptional() );
		
		return( getHTTPService().createVirtualServerConfig( name, "localhost", allOptions ) );
	}

		protected final HTTPServiceConfig
	getHTTPService() 
	{
		return getConfigConfig().getHTTPServiceConfig();
	}

		public void
	testCreateHTTPAccessLog()
		throws Exception
	{
	    if ( ! checkNotOffline( "testCreateRemove" ) )
	    {
	        return;
	    }
	    
		final String	NAME	= "VirtualServerConfigMgrTest-testCreateHTTPAccessLog";
		try
		{
			removeEx( NAME );
			final VirtualServerConfig	newVS	=
				(VirtualServerConfig)createProgeny( NAME, null);
			assert newVS != null;
			//trace( "newVS.getState: " + newVS.getState() );
			// assert newVS.getState().equals("disabled");
			
			assert( newVS.getHTTPAccessLogConfig() == null );
			
			final HTTPAccessLogConfig accessLog	=
				newVS.createHTTPAccessLogConfig( false, "${com.sun.aas.instanceRoot}/logs/access", null);
			assert ( accessLog != null );
			assert ( Util.getObjectName( accessLog ).equals( Util.getObjectName( newVS.getHTTPAccessLogConfig() ) ) );
			
			newVS.removeHTTPAccessLogConfig();
		}
		finally
		{
			remove( NAME );
		}
	}
}


