/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import javax.management.ObjectName;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;

import java.io.IOException;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

import com.sun.appserv.management.util.j2ee.J2EEUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.j2ee.statistics.*;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
    Base class for testing the com.sun.appserv MBeans relied
    upon by AMX.
 */
public class ComSunAppservTest
	extends AMXTestBase
{
    	public
    ComSunAppservTest()
    {
    }
	
    /**
        @return Map<String,ObjectName>, keyed by value of 'type' property from ObjectName
     */
        public Map<String,ObjectName>
    getAllComSunAppservCategory( final String category )
        throws IOException
    {
        final ObjectName    pattern =
            Util.newObjectName( "com.sun.appserv:category=" + category + ",*");
        final Set<ObjectName> objectNames =
            JMXUtil.queryNames( getMBeanServerConnection(), pattern, null );
        
        final HashMap<String,ObjectName>   m   = new HashMap<String,ObjectName>();
        for( final ObjectName objectName : objectNames )
        {
            final String    type    = objectName.getKeyProperty( "type" );
            if ( type != null )
            {
                m.put( type, objectName );
            }
        }
        
        return m;
    }
            
        public Map<String,ObjectName>
    getAllComSunAppservMonitor()
        throws java.io.IOException
    {
        return getAllComSunAppservCategory( "monitor" );
    }
    
        public Map<String,ObjectName>
    getAllComSunAppservConfig()
        throws java.io.IOException
    {
        return getAllComSunAppservCategory( "config" );
    }
  
	
	
}






