/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/support/ParamNameMapperTest.java,v 1.4 2006/03/09 20:30:59 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:59 $
 */
package com.sun.enterprise.management.support;

import java.util.Map;

import com.sun.appserv.management.util.misc.MapUtil;


/**
 */
public final class ParamNameMapperTest extends junit.framework.TestCase
{
		public
	ParamNameMapperTest( )
	{
	}

		public void
	testCreate()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
	}
	
		public void
	testEmpty()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "", m.mangleAttributeName( "" ) );
	}
	
	
		public void
	testSingleLowerCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "hello" ) );
		assertEquals( "hello_there", m.mangleAttributeName( "hello_there" ) );
	}
	
		public void
	testSingleLowerCaseLetter()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "x", m.mangleAttributeName( "x" ) );
	}
	
		public void
	testSingleUpperCaseLetter()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "x", m.mangleAttributeName( "X" ) );
	}
	
		public void
	testSingleAllUpperCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "HELLO" ) );
	}
	
		public void
	testSingleUpperCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "Hello" ) );
	}
	
		public void
	testMultipleLowerCaseWords()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello-there-you", m.mangleAttributeName( "hello-there-you" ) );
	}
	
	
		public void
	testMultipleUpperCaseWords()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello_there_you", m.mangleAttributeName( "HelloThereYou" ) );
	}
	
		public void
	testAcronyms1()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl_algorithm", m.mangleAttributeName( "SSLAlgorithm" ) );
	}
	
		public void
	testAcronyms2()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl_algorithm_enabled_today",
			m.mangleAttributeName( "SSLAlgorithmEnabledToday" ) );
	}
	
		public void
	testAcronyms3()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl-tls-http-jndi_algorithm",
			m.mangleAttributeName( "SSL-TLS-HTTP-JNDIAlgorithm" ) );
	}
	
	
		public void
	testOverrides()
	{
		final Map<String,String>	overrides	= MapUtil.newMap(
			new String[]
			{
				"SSLTLS", "ssl_tls",
				"GOOFY", "THECLOWN",
			}
		);
		
		final ParamNameMapper	m	= new ParamNameMapper( overrides );
		
		assertEquals( "ssl_tls", m.mangleAttributeName( "SSLTLS" ) );
		assertEquals( "THECLOWN", m.mangleAttributeName( "GOOFY" ) );
	}
	
}


