/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameServerInfo.java,v 1.3 2005/12/25 03:42:04 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:04 $
 */


package com.sun.enterprise.admin.dottedname;


/*
	This is the interface 'glue' that knows how to get server names, and how to get
	config names from server names, etc.  It isolates the DottedNameResolverForAliases
	code from direct knowledge of the server structure.
 */
public interface DottedNameServerInfo
{
	public static final class UnavailableException extends Exception
	{
		public UnavailableException( Throwable cause)	{ super( cause.getMessage(), cause ); }
		public UnavailableException( String msg )		{ super( msg ); }
	}
	
	public java.util.Set	getServerNames() throws UnavailableException;
	public java.util.Set	getConfigNames() throws UnavailableException;
	public String			getConfigNameForServer( String serverName ) throws UnavailableException;
	public String []		getServerNamesForConfig( String configName ) throws UnavailableException;
};



