/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans;

import com.sun.logging.LogDomains;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.EjbTimerEvent;

import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;

import java.util.logging.Logger;
import java.util.logging.Level; 

/**
 * object name for this mbean: <domainName>:type=ejb-timer-management,category=config
 * EJBTimerManagementMBean exposes list timers
 *
 * @author sridatta
 *
 */
public class EJBTimerManagementMBean 
        extends BaseConfigMBean 
        implements com.sun.enterprise.admin.mbeanapi.IEJBTimerManagementMBean
{
   
	public EJBTimerManagementMBean()
	{
	    super();
	}	
    
    private Logger getLogger()
    {
        if (_logger == null) {
            _logger = Logger.getLogger(LogDomains.ADMIN_LOGGER);
        }
        return _logger;
    }

    /**
     * Lists ALL the ejb timers  
     *
     * @param target is ignored. It is always assumed to be the 
     * 	             PE instance. can also be null.
     *
     * exception InstanceException 
     *
     * @return returns the list of timers as a string array
     */
    public String[] listTimers(String target) 
			throws ConfigException, InstanceException {
       
	fine("Entering list Timers"); 
	String server = getServerName(); 
        
	fine("List Timers: Sending Notification to server" + server);
	 
        String[] resStr = sendListTimerEvent(server, new String[] {server});
	fine("RESULT: " + resStr);
	if(resStr == null || resStr.length == 0) {
	   resStr = new String[] {"There are no Ejb Timers."};
	} 
	resStr[0] = server + ": " + resStr[0];
	return resStr;
    }
   
     protected String[] sendListTimerEvent(String server, String[] allServers) {
         AdminEvent event = new EjbTimerEvent(server, 
                        EjbTimerEvent.ACTION_LISTTIMERS, 
                        server, 
                        allServers);
         
	 event.setTargetDestination(server); 
         AdminEventResult res = forwardEvent(event);

	return (String[]) res.getAttribute(server,
			EjbTimerEvent.EJB_TIMER_CALL_RESULT_ATTRNAME);
     }
       
     protected AdminEventResult forwardEvent(AdminEvent e) {

        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent(e);
        return result;
    }
     
     private void fine(String s) {
         getLogger().log(Level.INFO, s); //FIXME. change to fine
     }

    
    private String getServerName() {
	return ApplicationServer.getServerContext().getInstanceName();
    } 
	///////////////////////////////////////////////////////////////////////////
	
	private static final	StringManager	_strMgr = 
                StringManager.getManager(EJBTimerManagementMBean.class);
	private static 	        Logger			_logger;
	///////////////////////////////////////////////////////////////////////////
}
