/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: HttpListenerVirtualServerAssociationMgr.java,v 1.3 2005/12/25 03:42:22 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeans;

//jdk imports
import java.util.Set;
import java.util.LinkedHashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

import com.sun.enterprise.util.i18n.StringManager;

//config imports
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

public class HttpListenerVirtualServerAssociationMgr
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(HttpListenerVirtualServerAssociationMgr.class);

    private final Config config;

    public HttpListenerVirtualServerAssociationMgr(ConfigContext   cctx,
                                                   String          configRef) 
        throws ConfigException
    {
        checkArg(cctx, strMgr.getString("http_listener_vs_assoc_mgr.null_context"));
        checkArg(configRef, strMgr.getString("http_listener_vs_assoc_mgr.null_config_ref"));
        final Domain domain = (Domain)cctx.getRootConfigBean();
        config = domain.getConfigs().getConfigByName(configRef);
        checkArg(config, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", configRef));
    }

    public void addHttpListenerRef(String listenerId) throws ConfigException
    {
        final String defaultVS = getHttpListener(listenerId).getDefaultVirtualServer();
        final Set s = getHttpListeners(defaultVS);
        s.add(listenerId);
        setHttpListeners(defaultVS, s);
    }

    public void deleteHttpListenerRef(String listenerId) throws ConfigException
    {
        VirtualServer[] servers = config.getHttpService().getVirtualServer();
        if (servers != null)
        {
            for (int i = 0; i < servers.length; i++)
            {
                Set httpListeners = getHttpListeners(servers[i].getId());
                if (httpListeners.contains(listenerId))
                {
                    httpListeners.remove(listenerId);
                    servers[i].setHttpListeners(setToStr(httpListeners));
                }
            }
        }
    }

    public void changeHttpListenerRef(String    listenerId, 
                                      String    oldVs, 
                                      String    newVs) 
        throws ConfigException
    {
        Set s = getHttpListeners(oldVs);
        s.remove(listenerId);
        setHttpListeners(oldVs, s);

        s = getHttpListeners(newVs);
        s.add(listenerId);
        setHttpListeners(newVs, s);
    }

    Set getHttpListeners(String vsID) throws ConfigException
    {
        return strToSet(getVirtualServer(vsID).getHttpListeners());
    }

    void setHttpListeners(String vsID, Set httpListeners)
        throws ConfigException
    {
        getVirtualServer(vsID).setHttpListeners(setToStr(httpListeners));
    }

    protected HttpListener getHttpListener(String id) throws ConfigException
    {
        HttpListener listener = config.getHttpService().getHttpListenerById(id);
        checkArg(listener, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", id));
        return listener;
    }

    protected VirtualServer getVirtualServer(String id) throws ConfigException
    {
        VirtualServer vs = config.getHttpService().getVirtualServerById(id);
        checkArg(vs, strMgr.getString("http_listener_vs_assoc_mgr.no_such_element", id));
        return vs;
    }

    private Set strToSet(String httpListeners)
    {
        final Set s = new LinkedHashSet();
        if (null != httpListeners)
        {
            StringTokenizer strTok = new StringTokenizer(httpListeners, ",");
            while (strTok.hasMoreTokens())
            {
                s.add(strTok.nextToken());
            }
        }
        return s;
    }

    private String setToStr(Set httpListeners)
    {
        String s = null;
        final Iterator it = httpListeners.iterator();
        if (it.hasNext())
        {
            StringBuffer sb = new StringBuffer();
            while (it.hasNext())
            {
                sb.append((String)it.next());
                if (it.hasNext()) { sb.append(','); }
            }
            s = sb.toString();
        }
        return s;
    }

    private void checkArg(Object o, Object msg) throws ConfigException
    {
        if (null == o)
        {
            throw new ConfigException(msg.toString());
        }
    }
}
