/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: MBeanExceptionFormatter.java,v 1.3 2005/12/25 03:42:23 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeans;

import javax.management.MBeanException;

/**
 * Helper class that formats the chained exception messages. 
 * The format of the returned message will be cause1(cause2(...)).
 * It also initializes the cause of the MBeanException which otherwise
 * is not initialized during MBeanException creation.
 */
public final class MBeanExceptionFormatter
{
    /**
     * This method returns an MBeanException instance with the message formatted
     * as msg(msg1(msg2...)). It also inits the cause of the MBeanException.
     * @param e The cause.
     * @param msg
     * @return A new instance of MBeanException.
     */
    public static MBeanException toMBeanException(  final Exception e, 
                                                    final String    msg )
    {
        final String s = getMessage(e, msg);
        final Exception cause = (e != null) ? e : new Exception(s);
        MBeanException mbe = new MBeanException(cause, s);
        mbe.initCause(cause);
        return mbe;
    }

    /**
     * @param t
     * @param cause1
     * @return Returns the formatted message cause1(cause2(...))
     */
    public static String getMessage(final Throwable t, final String cause1)
    {
        if (null == t) { return cause1; }
        final String cause = t.getMessage();
        final Throwable x = (t instanceof MBeanException) ? 
            ((MBeanException)t).getTargetException() : t.getCause();
        final String s = getMessage(x, cause);
        return formatMessage(cause1, s);
    }

    private static String formatMessage(String a, String b)
    {
        final StringBuffer sb = new StringBuffer("");
        boolean isValidA = (null != a) && (a.length() > 0);
        boolean isValidB = (null != b) && (b.length() > 0);
        if (isValidA) { sb.append(a); }
        if (isValidA && isValidB) { sb.append('('); }
        if (isValidB) { sb.append(b); }
        if (isValidA && isValidB) { sb.append(')'); }
        return sb.toString();
    }
}
