/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.admin.mbeans;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.common.exception.AFRuntimeException;

/**
 * The MBean is used for overriding the setAttribute functionality of the BaseConfigMBean.
 * When the monitoring-level of one of the following changes, the others are should also be
 * impacted. This is a special case that impact only the following components:
 * connector-service
 * jms-service
 * connector-connection-pool
 */
public class ModuleMonitoringLevelsMBean extends BaseConfigMBean {
    
    public static final String CONNECTOR_SERVICE_ATTR_NAME = "connector-service";
    public static final String JMS_SERVICE_ATTR_NAME = "jms-service";
    public static final String CONNECTOR_CONNPOOL_ATTR_NAME = "connector-connection-pool";
    public static final Logger sLogger = Logger.getLogger(AdminConstants.kLoggerName);

    /**
     * Creates a new instance of ModuleMonitoringLevelsMBean
     */
    public ModuleMonitoringLevelsMBean() {
    
    }
    
    public void setAttribute(Attribute attr) { 
        try {
            super.setAttribute(attr);
            String attrName = attr.getName();
            AttributeList otherAttrs = new AttributeList();
            sLogger.log(Level.FINE, "modulemonitoringlevelsmbean.attribute_name", attrName);
            if(attrName.equals(CONNECTOR_SERVICE_ATTR_NAME)) {
                
                otherAttrs.add(new Attribute(JMS_SERVICE_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(CONNECTOR_CONNPOOL_ATTR_NAME, attr.getValue()));
            }
            else if(attrName.equals(JMS_SERVICE_ATTR_NAME))
            {
                
                otherAttrs.add(new Attribute(CONNECTOR_CONNPOOL_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(CONNECTOR_SERVICE_ATTR_NAME, attr.getValue()));
            }
            else if(attrName.equals(CONNECTOR_CONNPOOL_ATTR_NAME)) 
            {
                
                otherAttrs.add(new Attribute(CONNECTOR_SERVICE_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(JMS_SERVICE_ATTR_NAME, attr.getValue()));
            }
            super.setAttributes(otherAttrs);
        } catch(AFRuntimeException afe) {
            throw afe;
        } catch(Exception e) {
            sLogger.log(Level.WARNING, "modulemonitoringlevelsmbean.set_failed");
            sLogger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }
    
    public AttributeList setAttributes(AttributeList attrs) {
        
        AttributeList attrList = new AttributeList();
        Iterator it = attrs.iterator();
        Attribute attr = null;
        while(it.hasNext()) {
            try {
                attr = (Attribute)it.next();
                setAttribute(attr);
            } catch(AFRuntimeException afe) {
                throw afe;
            } catch(Exception e) {
                sLogger.log(Level.WARNING, "modulemonitoringlevelsmbean.set_failed");
                sLogger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            attrList.add(attr);
        }
        return attrList;
    }
    
}
