/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: SecurityServiceMBean.java,v 1.3 2005/12/25 03:42:27 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeans;

//config imports
import com.sun.enterprise.admin.config.BaseConfigMBean;


public class SecurityServiceMBean extends BaseConfigMBean
{
    /**
     * Returns names of predefined AuthRealms' classes supported by security service.
     * @returns array of predefind AuthRealms' classes
     *
     */
    public String[] getPredefinedAuthRealmClassNames()
    {
        //!!!!!!!!!!!! (hardcoded for now until ss will implement backemnd support)
        return new String[]{
                "com.sun.enterprise.security.auth.realm.file.FileRealm",
                "com.sun.enterprise.security.auth.realm.certificate.CertificateRealm",
                "com.sun.enterprise.security.auth.realm.ldap.LDAPRealm",
                "com.sun.enterprise.security.auth.realm.solaris.SolarisRealm"};
    }
}
