/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: MBeanExceptionFormatterTest.java,v 1.3 2005/12/25 03:43:13 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeans;

//junit imports
import junit.framework.*;
import junit.textui.TestRunner;

//JMX imports
import javax.management.MBeanException;

public class MBeanExceptionFormatterTest extends TestCase
{
    public void testMBeanException()
    {
        Exception targetEx = new Exception();
        MBeanException mbe = new MBeanException(targetEx);
        Assert.assertEquals(targetEx, mbe.getTargetException());
        Assert.assertEquals(null, mbe.getCause());
        Assert.assertEquals(null, mbe.getMessage());
        Assert.assertEquals(null, mbe.getTargetException().getMessage());

        targetEx = new Exception("actual message");
        mbe = new MBeanException(targetEx);
        mbe.initCause(targetEx);
        Assert.assertEquals(targetEx, mbe.getCause());
        Assert.assertEquals(null, mbe.getMessage());

        mbe = toMBeanException(null, null);
        Assert.assertEquals(null, mbe.getMessage());
        Assert.assertTrue(null != mbe.getCause());
        Assert.assertTrue(null != mbe.getTargetException());

        mbe = toMBeanException(null, "a");
        Assert.assertEquals("a", mbe.getMessage());

        Exception e = new Exception("b", new Exception("c", new Exception("d")));
        mbe = toMBeanException(e, "a");
        Assert.assertEquals("a(b(c(d)))", mbe.getMessage());
        Assert.assertEquals(e, mbe.getCause());
        Assert.assertEquals(e, mbe.getTargetException());

        mbe = toMBeanException(e, null);
        Assert.assertEquals("b(c(d))", mbe.getMessage());

        e = new Exception();
        mbe = toMBeanException(e, "a");
        Assert.assertEquals("a", mbe.getMessage());

        e = new Exception("b", null);
        mbe = toMBeanException(e, "a");
        Assert.assertEquals("a(b)", mbe.getMessage());

        e = new Exception("b", new Exception(null, new Exception("c")));
        mbe = toMBeanException(e, "a");
        Assert.assertEquals("a(b(c))", mbe.getMessage());
    }

    MBeanException toMBeanException(final Exception e, final String msg)
    {
        return MBeanExceptionFormatter.toMBeanException(e, msg);
    }

    public MBeanExceptionFormatterTest(String name) throws Exception
    {
        super(name);
    }

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }

    public static junit.framework.Test suite()
    {
        TestSuite suite = new TestSuite(MBeanExceptionFormatterTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception
    {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(
                MBeanExceptionFormatterTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}