/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EndTimeAccessObjectImpl.java
 *
 * Created on August 3, 2005, 2:15 PM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import com.sun.enterprise.admin.monitor.callflow.TableInfo;
import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;
/**
 * Access Object to access END_TIME_TBL.
 * Table is created to store the timing information whenever a 
 * container transitions to another container or the application code
 * Table is used to calculate the Pie Chart information for time
 * spent in individual containers as well as time spent in an end
 * user application code.
 * @author Harpreet Singh
 */
public class EndTimeAccessObjectImpl extends AbstractTableAccessObject{
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static EndTimeAccessObjectImpl _singletonET;    
    
    /** Creates a new instance of EndTimeAccessObjectImpl */
    private EndTimeAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        super.tableName = TableInfo.END_TIME_TABLE_NAME +
                serverName.toUpperCase();
    }

    public static TableAccessObject getInstance() {
        if(_singletonET == null)
            _singletonET = new EndTimeAccessObjectImpl();        
        return _singletonET;
    }
    public boolean insert(java.sql.PreparedStatement pstmt, TransferObject[] transferObject) {
       // sanity
        if (pstmt == null)
            return false;
        boolean result = false;
        try{
            
            for (int i = 0 ; i<transferObject.length; i++) {
                EndTimeTO endTimeTO = (EndTimeTO)transferObject[i];
                pstmt.setString(1, endTimeTO.getRequestId());
                pstmt.setLong(2, endTimeTO.getTimeStamp());
                pstmt.setString(
                        3, endTimeTO.getContainerTypeOrApplicationType());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result =  (updated.length == transferObject.length)? true : false;
        }  catch(BatchUpdateException bue) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }catch (SQLException se) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public boolean dropTable(java.sql.Connection connection) {
        super.con = connection;
        return super.createStatmentAndExecuteUpdate(
                TableInfo.DROP_TABLE_END_TIME_SQL,
                TableInfo.END_TIME_TABLE_NAME);        
    }

    public boolean createTable(java.sql.Connection connection) {
        super.con = connection;
        return super.createTable(
                TableInfo.CREATE_TABLE_END_TIME_SQL,
                TableInfo.END_TIME_TABLE_NAME);        
        
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(
                TableInfo.INSERT_INTO_TABLE_END_TIME_SQL, 
                TableInfo.END_TIME_TABLE_NAME);
        return newsql;            
    }

    public String getDeleteSQL () {
        String newsql = super.updateSqlWithTableName (
                TableInfo.DELETE_FROM_TABLE_END_TIME_SQL,
                TableInfo.END_TIME_TABLE_NAME);
        return newsql;
    }
    
}

