/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RequestStartAccessObjectImplTest.java
 * JUnit based test
 *
 * Created on July 13, 2005, 9:32 AM
 */

package com.sun.enterprise.admin.monitor.callflow;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import junit.framework.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;

/**
 *
 * @author Harpreet Singh
 */
public class RequestStartAccessObjectImplTest extends TestCase {
    
    Connection con = null;
    TableAccessObject rs = null;
    PreparedStatement pstmt = null;
    RequestStartTO[] requestStart = new RequestStartTO[10];
    
    public RequestStartAccessObjectImplTest(String testName) {
        super(testName);

    }
    
    public void testCreateTable() {
        System.out.println("RequestStart: testCreateTable");
        boolean result = false;
        try{
            result = rs.createTable(con);
            System.out.println("Create Table returned = "+ result);
        }catch (Exception e){
            e.printStackTrace();
        }
        assertTrue(result);
    }
    public void testInsert (){
        System.out.println(" testStoreRequestStart");
        try{
            String insertSQL = rs.getInsertSQL();
            System.out.println (" Insert SQL :"+ insertSQL);
            pstmt = con.prepareStatement(insertSQL);
            for (int i = 0; i < requestStart.length; i++) {
                requestStart[i] = new RequestStartTO();
                requestStart[i].requestId = "RequestID_"+i;
                requestStart[i].timeStamp = System.nanoTime();
                requestStart[i].requestType = RequestType.REMOTE_EJB;
                requestStart[i].timeStampMillis = System.currentTimeMillis();
                requestStart[i].ipAddress = "129.129.129.129";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        boolean result = rs.insert (pstmt, requestStart);
        System.out.println("testStoreRequestStart returned = "+result);
        assertTrue (result);
    }
    
    public void testDropTable () {
        System.out.println("RequestStart : testDropTable");
        boolean result = rs.dropTable(con);
        System.out.println("Drop Table returned = "+result);
        assertTrue (result);
    }
    protected void setUp(){
        try{
            // TODO code application logic here
            String url="jdbc:derby://localhost:1527/sun-callflow;retrieveMessagesFromServerOnGetMessage=true;create=true;";            
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            con = DriverManager.getConnection(url, "APP", "APP");         
            // drop request start table
            rs = RequestStartAccessObjectImpl.getInstance();            
        } catch (Exception e){
            e.printStackTrace();
        }
    }
   
    protected void tearDown() {
        try{
            con.close();
        } catch (Exception e){
            e.printStackTrace();
        }
        finally {
            con = null;
        }
    }
    public static void main(String args[]) {
        junit.textui.TestRunner.run(RequestStartAccessObjectImplTest.class);
    }

    
}
