/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RepositoryException.java
 *
 * Created on August 22, 2003, 11:21 AM
 */

package com.sun.enterprise.admin.servermgmt;

/**
 *
 * @author  kebbs
 */
public class RepositoryException extends java.lang.Exception {
    
       /** Constructs a new InstanceException object.
     * @param message
     */
    public RepositoryException(String message)
    {
        super(message);
    }

    /** Constructs a new InstanceException object.
     * @param cause
     */
    public RepositoryException(Throwable cause)
    {
        //When created without a message, we take the message of our cause
        this(cause.getLocalizedMessage(), cause);
    }

    /** Constructs a new InstanceException object.
     * @param message
     * @param cause
     */
    public RepositoryException(String message, Throwable cause)
    {
        super(message, cause);
    }

    private final String PREFIX = "( ";
    private final String POSTFIX = " )";
   
    private String format(String msg, String causeMsg, Throwable cause)
    {
        if (cause != null) {
            if (msg != null) {
                if (causeMsg != null) {
                    msg = causeMsg;
                } else {
                    msg = cause.toString();
                }
            } else if (causeMsg != null && !msg.equals(causeMsg)) {
                msg += PREFIX + causeMsg + POSTFIX;               
            } else if (causeMsg == null) {
                msg += PREFIX + cause.toString() + POSTFIX;
            }
        }
        return msg;
    }

    /** If there is a cause, appends the getCause().getMessage()
     *  to the original message.
     */    
    public String getMessage()
    {
        String msg = super.getMessage();
        Throwable cause = super.getCause();
        if (cause != null) {
            msg = format(msg, cause.getMessage(), cause);
        }
        return msg;
    } 
    
    /** If there is a cause, appends the getCause().getMessage()
     *  to the original message.
     */
    public String getLocalizedMessage()
    {
        String msg = super.getLocalizedMessage();
        Throwable cause = super.getCause();
        if (cause != null) {
            msg = format(msg, cause.getLocalizedMessage(), cause);
        }
        return msg;
    }       
}
