/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Set;
import java.util.logging.Level;


public class ClusterTest extends GenericValidator {
    
    public ClusterTest(ValidationDescriptor desc) {
        super(desc);
    } 

    void validateAdd(final ConfigContextEvent cce, final Result result)  throws ConfigException{
        checkNameNotDomain(cce, result);
        checkConfigRefValidity(cce, result);
    }

    void validateUpdate(final ConfigContextEvent cce, final Result result) throws ConfigException{
        checkNameNotDomain(cce, result);
        preventInvalidConfigRef(cce, result);
    }



    void checkNameNotDomain(final ConfigContextEvent cce, final Result result)  throws ConfigException{
        final Cluster c = getCluster(cce);
        if ("domain".equals(c.getName())){
            result.failed(smh.getLocalString(getClass().getName() + ".illegalClusterName", 
                                             "Illegal Cluster Name: {0}", new Object[]{c.getName()}));
        }
    }
    
    private Cluster getCluster(final ConfigContextEvent cce)  throws ConfigException{
        return (Cluster) cce.getValidationTarget();
    }
    

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce); // Before doing custom validation do basic validation
        boolean flag = false;
        String choice = cce.getChoice();
        try {
            if (choice.equals(StaticTest.UPDATE)){
                validateUpdate(cce, result);
            } else if (choice.equals(StaticTest.ADD)){
                validateAdd(cce, result);
            }
        }
        catch (ConfigException ce){
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
            
        return result;
    }

    private final void preventInvalidConfigRef(final ConfigContextEvent cce, final Result result) throws ConfigException {
        if (cce.getName().equals(ServerTags.CONFIG_REF)){
            checkConfigRefValidity((String) cce.getObject(), result);
        }
    }
    
    private final void checkConfigRefValidity(final ConfigContextEvent cce, final Result result) throws ConfigException {
        checkConfigRefValidity(getCluster(cce).getConfigRef(), result);
    }
    
            
    private void checkConfigRefValidity(final String config_ref, final Result result){
        if (config_ref.equals(StaticTest.DAS_CONFIG_NAME)){
            result.failed(smh.getLocalString(getClass().getName()+".cannotHaveDASasConfig",
                                             "The configuration of the Domain Administration Server (named {0}) cannot be referenced by a cluster",
                                             new Object[]{StaticTest.DAS_CONFIG_NAME}));
        } else if (config_ref.equals(StaticTest.CONFIG_TEMPLATE_NAME)){
            result.failed(smh.getLocalString(getClass().getName()+".cannotHaveTemplateConfig",
                                             "The default configuration template (named {0}) cannot be referenced by a cluster",
                                             new Object[]{StaticTest.CONFIG_TEMPLATE_NAME}));

        }
    }

}


