/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;

import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.ConfigContext;

import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import java.lang.StringBuffer;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.net.UnknownHostException;
import java.net.InetAddress;





/* Utility functions
 * Author : srini@sun.com
 **/ 

public class StaticTest {
    
    /* Adding various constants to this file. This should remove the hard coded values that
     * we are using in various tests.
     */
    
    // Represents the ADD configbean request
    public static final String ADD = "ADD";
    // Represents the DELETE configbean request
    public static final String DELETE = "DELETE";
    // Represents the UPDATE configbean request
    public static final String UPDATE = "UPDATE";
    // Represents the SET configbean request
    public static final String SET = "SET";
    // Represents the VALIDATE configbean request
    public static final String VALIDATE = "VALIDATE";
    
    // flag to check for file existence
    public static boolean fileCheck = false;
    // flag to check for classpath existence
    public static boolean classPathCheck = false;
    // flag to check for javaHome existence
    public static boolean javaHomeCheck = false;
    
    public StaticTest() {
    }
    

        /**
         * Check the IP address syntax of the given address. If its
         * invalid throw UnknownHostException. Ignore the address if
         * its a token
         */
    public static void checkIPAddress(final String addr) throws UnknownHostException{
        if (valueContainsTokenExpression (addr) || validSymbolicAddress(addr)){
            return;
        } else {
            InetAddress.getByName(addr);            
        }
    }

        /**
           Indicate if the given address is a symbolic
           address. i.e. is "any", "inaddr_any" or "localhost", in any case.
         */
    private static boolean validSymbolicAddress(final String address){
        return address.equalsIgnoreCase("ANY") ||
        address.equalsIgnoreCase("INADDR_ANY") || 
        address.equalsIgnoreCase("localhost");
    }
    
        
    // Method to get the reference to config 
    public static Config getConfig(ConfigContext context) {
        Config mConfig=null;
        try {
            mConfig = ServerBeansFactory.getConfigBean(context);
        } catch(Exception e) {
        }
        return mConfig;
    }
    
    public static boolean isOptionsValid(String options) {
        boolean flag = true;
        StringTokenizer token = new StringTokenizer(options," ");
        while(token.hasMoreTokens())  {
              if(!token.nextToken().startsWith("-")) {
                    flag = false;
                    break;
              }
        }
        return flag;
    }
    
    public static boolean isClassPathValid(String path) {
        boolean flag = true;
        StringTokenizer token = new StringTokenizer(path, File.pathSeparator);
        while(token.hasMoreTokens()) {
            File f = new File(token.nextToken());
            // User requires to validate the file path check for existence, else blank check
            if(classPathCheck) {
                if(!f.exists()) {
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }
    
    /**
     * Verifies that the given path is a valid java-home path.
     *
     * @param path The java-home path to be validated.
     * @return boolean true if valid false if invalid
     */
    public static boolean isJavaHomeValid(String path) {
        boolean flag = true;
        if(javaHomeCheck) {
            String jdkPath = path + File.separator + "bin" + File.separatorChar;
            if(System.getProperty("os.name").startsWith("Win")) {
                jdkPath = jdkPath + "java.exe";
            } else {
                jdkPath = jdkPath + "java";
            }
            StringTokenizer token = new StringTokenizer(path, File.pathSeparator);
            while(token.hasMoreTokens()) {
                File f = new File(token.nextToken());
                // User requires to validate the file path check for existence, else blank check
                if(!f.exists()) {
                    flag = false;
                    break;
                }
            }        
        }
        return flag;
    }
    

    public static Vector tokens(String value) {
        StringTokenizer token = new StringTokenizer(value,",");
        Vector test = new Vector();
        while(token.hasMoreTokens()) 
                  test.add(token.nextToken().trim());
        return test;
    }

    public static boolean isIdInList(String list, String poolId)
    {
        return null != poolId && tokens(list+"").contains(poolId);
    }
    

    
    static void setJavaHomeCheck(boolean check) {
        javaHomeCheck = true;
    }
    
    public static boolean valueContainsTokenExpression(final Object value){
        return null != value && value instanceof String && token_pattern.matcher((String) value).lookingAt();
    }
    
    private static Pattern token_pattern = Pattern.compile("\\$\\{[^}]*}");

        /**
           Name of config reserved for DAS server
        */
    public static final String DAS_CONFIG_NAME = "server-config";

        /**
           Name of config used as a template
         */
    public static final String CONFIG_TEMPLATE_NAME = "default-config";
    

}
