#!/usr/bin/perl
    $indent_size = 3;

    if ($#ARGV != 2) {
      printUsage();
      exit;
    }
    $xml_file = shift(@ARGV);
    $out_file = shift(@ARGV);
    $indent_size = shift(@ARGV);
    
    print "input xml file: ", $xml_file , "\n";
    print "output file: ", $out_file, "\n";
    print "indent: ", $indent_size, "\n";

    $super_indent = "                                                                              ";

    open(RNG, $xml_file) || warn "Can't open file $xml_file: $!\n";
    open(OUTP, ">".$out_file) || warn "Can't open file $out_file: $!\n";

  
    while (<RNG>) {
        $nesting_level = 0;
        if((/^<name\-lists /) || (/^<\/name\-lists/)) {
           # just to distinguish from name list 
        } else {
            if((/^<name\-list /) || (/^<\/name\-list/)) {
                $nesting_level = 1;
            } else {
                if(/^<forms\-from/) {
                    $nesting_level = 2
                }
                else {
                    if(/^<referenced\-by /) {
                       $nesting_level = 3
                    }
                }    
            }
        }
        
        if(/^<name\-list /) {
                print OUTP "\n<!--**************************************************************-->\n";
        }
        if($nesting_level!=0) {
            print OUTP substr($super_indent,1,$indent_size*$nesting_level);
        }
        s/^\s*(<name\-list.*) (full\-name=\".*\") (scope=\".*\")(.*)$/$1\n           $2\n           $3$4/;
        print OUTP $_ ;
    }
    exit;
   
sub printUsage
{
      print "usage perl mergeRngWithNAmeDomains domain.rng names.xml out.xml";
   print ("Set idents in xml file.\n");
   print ("Usage: \n");
   print ("       generateNameDomains.pl <input xml file> <output file> <size-of-indent>");
}