/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import org.xml.sax.InputSource;
import java.io.FileReader;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;



public class SimpleTransform
{
    public static void main(String [] args) throws Exception {
        String in = null;
        String xsl = null;
        String out = null;
        
        if (args.length != 6){
            System.err.println("Insufficient args: SimpleTransform -in file -xsl file -out file");
            System.exit(1);
        }

        for (int i = 0; i < args.length; i++){
            if (args[i].equals("-in")){
                in = args[++i];
            } else if (args[i].equals("-xsl")){
                xsl = args[++i];
            } else if (args[i].equals("-out")){
                out = args[++i];
            } else {
                System.err.println("Unrecognized arg: "+args[i]);
                System.exit(1);
            }
        }
        

        final TransformerFactory f = TransformerFactory.newInstance();
        final Transformer t = f.newTransformer(new StreamSource(new File(xsl)));
//         final Source src = new SAXSource(XMLReaderFactory.newInstance(System.err),
//                                    new InputSource(in));
        final Source src = new SAXSource(new VariableResolver(),
                                   new InputSource(in));
        final Result res = new StreamResult(out);
        
        t.transform(src, res);
    }
    

}
