/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;

/**
 * Runtime context needed for Filter's execution 
 */
public class FilterContext {

    /**
     * Public constructor.
     *
     * @param ep        Endpoint information
     * @param callFlow  true, if CallFlow is enabled, otherwise false
     * @param info      Physical transport information
     * @param ctx       Message context for this web service invocation
     * @param id        Id of the message
     */
    public FilterContext(Endpoint ep, boolean callFlow, TransportInfo info, 
        SOAPMessageContext ctx, String id, String f) {

        endpoint = ep;
        tInfo = info;
        mCtx = ctx;
        mId = id;
        fqn = f;
        mIsCallFlowEnabled = callFlow;
        // note down when the filter context is created
        execTime = System.currentTimeMillis();
    }
    
    public Endpoint getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(Endpoint e) {
        endpoint = e;
    }

    public TransportInfo getTransportInfo() {
        return tInfo;
    }

    public void setTransportInfo(TransportInfo t) {
        tInfo = t;
    }

    public SOAPMessageContext getMessageContext() {
        return mCtx;
    }

    public void setMessageContext(SOAPMessageContext ctx) {
        mCtx = ctx;
    }

    public String getFullyQualifiedName() {
        return fqn;
    }

    public void setFullyQualifiedName(String f) {
        fqn = f;
    }

    public String getMessageId() {
        return mId;
    }

    public boolean isCallFlowEnabled() {
        return mIsCallFlowEnabled;
    }

    public long getExecutionTime() {
        return execTime;
    }

    public void setExecutionTime(long e) {
        execTime = e;
    }

    // PRIVATE VARIABLES

    private Endpoint endpoint;
    private TransportInfo tInfo;
    private SOAPMessageContext mCtx;
    private String mId;
    private String fqn;
    private boolean mIsCallFlowEnabled;
    private long execTime;
}
