/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.management.j2ee.statistics.Stats;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.logging.LogDomains;


/**
 * Provides an implementation of the MonitoringLevelListener interface to
 * receive callbacks from admin regarding change in the monitoring level.
 * Though there are 3 monitoring levels defined by JSR77, we support
 * only 2 levels - OFF and ON (HIGH/LOW). So essentially, HIGH and LOW
 * for us is only ON
 *
 * @author Satish Viswanatham
 * @since s1aspe 9.0
 */
public class WSMonitoringLevelListener implements MonitoringLevelListener {
    
    private MonitoringRegistry registry_;

    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;

    private static Logger _logger = null; // LogDomains.getLogger( LogDomains.RSR_LOGGER );

    public WSMonitoringLevelListener(String n, String mName, String ctxRoot,
        boolean isa, String v, String appName, boolean isEjbM) {
        name = n;
        moduleName = mName;
        this.ctxRoot = ctxRoot;
        isStandAlone = isa;
        vs = v;
        j2eeAppName = appName;
        isEjbModule = isEjbM;
    }

    /**
     * @see com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener
     * #setLevel(com.sun.enterprise.admin.monitor.registry.MonitoringLevel)
     * @deprecated
     */
    //remove after admin removes it
    public void setLevel( MonitoringLevel level ) {}
    
    /**
     * This is the callback invoked by the MonitoringRegistry
     * on change in monitoring level
     * 
     * @param from - the past level
     * @param to - the new level
     * @param handback - the Stats object this listener was registered for
     * @deprecated 
     */
    public void changeLevel( MonitoringLevel from, MonitoringLevel to,
        Stats handback ) {

        try {
            new MonitoringLifeCycleImpl().instrumentMonitoring(name, 
                moduleName, ctxRoot, isStandAlone, vs, j2eeAppName, from, to,
                isEjbModule);
        } catch (Exception e) {
            // XXX log warning message
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, 
            MonitoredObjectType type) {

        try {
            new MonitoringLifeCycleImpl().instrumentMonitoring(name, 
                moduleName, ctxRoot, isStandAlone, vs, j2eeAppName, from, to,
                isEjbModule);
        } catch (Exception e) {
            // XXX log warning message
        }
    }

    // -------- PRIVATE VARIABLES -----

    private String ctxRoot = null;
    String name = null;
    String moduleName = null;
    boolean isStandAlone;
    String vs = null;
    String j2eeAppName = null;
    boolean isEjbModule;
}
