/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.pool.spi;

import java.util.Collection;

/**
 * Pool used to keep track of SOAP messages.
 */
public interface Pool {

    /**
     * Returns the name of this pool. 
     *
     * @return  name of this pool
     */
    public String getName();

    /**
     * Returns the object for the given key. 
     *
     * @param  key  key used to put objects in the pool
     *
     * @return  object for the given key or null
     */
    public Object get(Object key);

    /**
     * Adds the object to the pool. 
     *
     * @param  key  key used to put this object
     * @param  val  actual object to be added to the pool
     *
     * @return  previous value for this key or null
     */
    public Object put(Object key, Object val);

    /**
     * Removes this keyed entry from the pool.
     *
     * @param  key  key of the entry that is targeted to be removed
     *
     * @return  removed entry or null if key not found
     */
    public Object remove(Object key);

    /**
     * Removes all mappings from this pool.
     */
    public void clear();

    /**
     * Returns the number of mappings in this pool. 
     *
     * @return  current number of mappings in this pool
     */
    public int size();

    /**
     * Returns the maximum number of mappings allowed in this pool.
     *
     * @return  max number of mappings allowed
     */
    public int getMaxSize();

    /**
     * Returns true if this pool contains mapping for the specified key.
     *
     * @param  key  the presence of the key to be tested
     *
     * @return  true if this pool contains mapping for the specified key
     */
    public boolean containsKey(Object key);

    /**
     * Returns true if this pool contains mapping for the specified value. 
     * 
     * @param  val  the presence of the value to be tested
     *
     * @return  true if this pool contains mapping for the specified value
     */
    public boolean containsValue(Object val);

    /**
     * Returns a collection view of the values contained in this pool. 
     *
     * @return  a collection view of the values contained in this pool
     */
    public Collection values();

    /**
     * Resets the max size of the pool. If new size is less than current 
     * size, all extra entries in the pool will be removed.
     *
     * @param  size  new max size of the pool
     */
    public void resize(int size);
}
