/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.repository.spi;

import java.util.Map;

/**
 * This is the mechanism to provide web service crawling. A RepositoryProvider
 * implementation is a class that extends the RepositoryProvider abstract class.
 * <br>
 * A RepositoryProvider implemented is identified by its fully qualified class
 * name. The default RepositoryProvider is 
 * com.sun.enterprise.admin.repository.spi.impl.ApplicationServerProvider
 */
public interface RepositoryProvider {

    /**
     * Returns the unique identifier for this RepositoryProvider object.
     *
     * @return fully qualified class name of this RepositoryProvider
     */
    public String getProviderID();

    /**
     * Returns the list of module descriptors locations that contains web 
     * service implementation and associated properties.
     *
     * @return the map of module information
     */
    public Map getWebServiceModules();
}
