/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.stats.spi;


/**
 * A Class for providing stats for Web Service Endpoint.
 *
 * @author Satish Viswanatham
 */
public interface WebServiceEndpointStatsProvider
{
    public long getAverageResponseTime();

    public long getMinResponseTime();

    public long getMaxResponseTime();

    public long getResponseTime();

    public int getTotalFailures();

    public int getTotalSuccesses();

    public int getTotalAuthFailures();

    public int getTotalAuthSuccesses();

    public double getThroughput();

    public int getRequestSize();

    public int getResponseSize();

    public String getClientHost();

    public String getClientUser();

    public String getFaultCode();

    public String getFaultString();

    public String getFaultActor(); 

    public void reset();

    public long getLastResetTime();
}
