/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.config.spi.Constants;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;

import javax.xml.transform.stream.*;
import javax.xml.transform.*;
import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPPart;

import java.io.StringBufferInputStream;
import java.io.StringWriter;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
 
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.XMLFilter;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerConfigurationException;

import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXResult;

import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.HashMap;
import com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule;
import com.sun.enterprise.util.SystemPropertyConstants;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * Ordered XSLT filter chain. 
 */
public class FilterChain {

    /**
     * Public Constructor.
     *
     * @param appId   name of the application
     * @param endpoint   end point name for which stats are collected
     */
    public FilterChain() throws TransformException {
        try {
            // Set up to the Transformer
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            _reader = parser.getXMLReader();
   
            _stf = (SAXTransformerFactory) TransformerFactory.newInstance();
            _transformer = _stf.newTransformer();
        } catch(Exception e) {
            throw new TransformException(e);
        }
    }

    public synchronized void addFilter(TransformationRule[] tRules, 
            boolean reverse) throws TransformException {
        if ((tRules == null) || (tRules.length == 0)) {
            return;
        }
        if ( reverse == false) {    
            for(int idx =0; idx < tRules.length; idx++) {
                addFilter(idx, tRules[idx]);
            }
        } else {
            int index =0;
            for(int idx = tRules.length -1; idx > -1; idx--) {
                addFilter(index, tRules[idx]);
                index++;
            }
        }
    }

    public synchronized void addFilter(int index, TransformationRule tRule) 
            throws TransformException {
        try {
            if (tRule == null) {
                return;
            }
            String name = tRule.getName();
            // check if the Rule File Location is relative, then prepend the 
            // instance root to the path
            File stylesheet = new File(tRule.getRuleFileLocation());
            if ( !stylesheet.isAbsolute()) {
                // construct the absolute path
                String instanceRoot = System.getProperty(
                    SystemPropertyConstants.INSTANCE_ROOT_PROPERTY);

                stylesheet = new File( instanceRoot 
                 + File.separator+tRule.getRuleFileLocation());
            } 
            XMLFilter filter = _stf.newXMLFilter(new StreamSource(stylesheet));
            addToList(index,name,filter);
        } catch(Exception e) {
            String msg = _stringMgr.getString("rule_not_compiled",
            tRule.getRuleFileLocation(), tRule.getName());
            _logger.log(Level.WARNING, msg); 
            throw new TransformException(e);
        }
    }

    public synchronized void removeFilter(int index) {
        removeFromList(index);
    }

    private void addToList(int index, String name, XMLFilter filter) {
        FilterData parent = null;
        if ( index == 0) {
            parent = null;
            filter.setParent(_reader);
        } else {
            parent = (FilterData) filterList.get(index-1);
            filter.setParent(parent.getFilter());
            // check if child the exists
            if ( filterList.size() -1 > index) {
                FilterData child = (FilterData) filterList.get(index);
                if ( child != null) {
                    child.getFilter().setParent(filter);
                }
            }
        }

        filterList.add(index, new FilterData(name,filter));
    }

    private void removeFromList(int index) {
        FilterData current = (FilterData) filterList.get(index);

        if ( current == null) {
            return;
        }

        FilterData parent = null;
        if ( index == 0) {
            parent = null;
        } else {
            parent = (FilterData) filterList.get(index-1);
        }

        FilterData child = null;
        if ( index +1 < filterList.size()) {
            child = (FilterData) filterList.get(index+1);
        }
        if ( child != null) {
            if ( parent == null) {
                child.getFilter().setParent(_reader);
            } else {
                child.getFilter().setParent(parent.getFilter());
            }
        }
    }

    /**
     * Invoke the filter.
     * 
     * @param  context  filter context 
     */
    public synchronized void process(FilterContext context) 
            throws TransformException {

        if (( filterList.size() == 0 ) || (context == null)) {
            return;
        }

        try {

             SOAPMessageContext smc = context.getMessageContext();
             SOAPMessage sm = smc.getMessage();
             SOAPPart sp = sm.getSOAPPart();
             // gets the SOAP envelope as a JAXP Source object.
             Source s = sp.getContent();

            // Set up the transformer to process the SAX events generated
            // by the last filter in the chain
            InputSource inputSrc = SAXSource.sourceToInputSource(s);
            SAXSource transformSource = new SAXSource( 
                ((FilterData)filterList.getLast()).getFilter(), inputSrc);

             StringWriter sw = new StringWriter(STRING_WRITER_INIT_SIZE);
             Result r = new StreamResult(sw);
             _transformer.transform(transformSource, r);
             // get the string from the result.
             sw.flush();
             sw.close();
             StringBufferInputStream in = new StringBufferInputStream(
                            sw.toString());
             MessageFactory mFactory = MessageFactory.newInstance();
             SOAPMessage resMsg = mFactory.createMessage(null, in);
                 smc.setMessage(resMsg);


        } catch(Exception e) {
            _logger.fine("XSLT transformation failed for " 
                + context.getFullyQualifiedName());
            throw new TransformException(e);
        }

    }

    // -- PRIVATE - VARIABLES -------------------------
    LinkedList filterList = new LinkedList();
    XMLReader _reader = null;
    SAXTransformerFactory _stf = null;
    Transformer _transformer = null;

    // intial size for StringWriter
    static final int STRING_WRITER_INIT_SIZE = 4028;

     private static final Logger _logger = 
        Logger.getLogger(LogDomains.ADMIN_LOGGER);
    private static final StringManager _stringMgr = 
        StringManager.getManager(FilterChain.class);

}
