/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConfigHelperTest.java
 *
 * Created on June 10, 2005, 2:45 PM
 */

package com.sun.enterprise.admin.wsmgmt.registry;

/**
 *
 * @author Harpreet Singh
 */

import com.sun.enterprise.admin.wsmgmt.registry.*;

import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.admin.wsmgmt.registry.ConfigHelper;


import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

public class ConfigHelperTest extends TestCase {
   
    public ConfigHelperTest(String name) {
        super(name);        
    }       

    public void testListRegistryLocations() throws ConfigException {                        
        try {
            String[] locations = ch_query.listRegistryLocations();
            System.out.println("Looking up Connection Jndi Name. Name" +
                    " should be "+POOL_NAME);
            
            if(locations.length == 1){
                System.out.println("Locations = "+ locations[0]);
                assertEquals("Looked up Registry Location ", POOL_NAME, 
                        locations[0]);
            } else{
                fail(" Returned wrong number of RegistryLocation");
            }
        } catch (ConfigException ce) {
            ce.printStackTrace();
            throw ce;
        }
    }

 
    protected void setUp() {
        try{
            System.out.println("ConfigHelperTest");
            ch_query = ConfigHelper.getInstanceToQueryRegistryLocations();
            ConfigContext ctx = ConfigFactory.createConfigContext(URL);
            ch_query.setConfigContext(ctx);            
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    private final static String URL = 
       "tests/com/sun/enterprise/admin/wsmgmt/registry/connectionpool-domain.xml";
    private final static String POOL_NAME = "foojndi";
    
    private ConfigHelper ch_query = null;
    private ConfigHelper ch_add_delete = null;
    public static void main(String args[]) {
        junit.textui.TestRunner.run(ConfigHelperTest.class);
    }
}
