/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;

/**
 * Instances encapsulate all information necessary for an AnnotationHandler 
 * to process an annotation. In particular, instances of this class provide 
 * access to :
 *
 * <p>
 * <li> the Annotation instance 
 * <li> the ProcessingContext of the tool
 * <li> the AnnotatedElement which is a reference to the annotation element 
 * (Type, Method...).
 * </p>
 *
 * @see java.lang.annotation.Annotation, java.lang.reflect.AnnotatedElement
 *
 * @author Jerome Dochez
 *
 */
public class AnnotationInfo {

    // the annotated element 
    final private AnnotatedElement annotatedElement;

    // the annotation   
    final private Annotation annotation;
    
    // the processing context
    final private ProcessingContext context;
    
    // the element type
    final private ElementType type;

    /**
     * Creates a new instance of AnnotationInfo with all the information 
     * necessary to process an annotation.
     *
     * @param context the annotation processor processing context
     * @param element the annotated element
     * @param annotation the annotation 
     */
    public AnnotationInfo(ProcessingContext context, AnnotatedElement element, 
            Annotation annotation, ElementType type) {
        
        this.context = context;
        this.annotatedElement = element;
        this.annotation = annotation;
        this.type = type;
    }

    /**
     * @return the annotated element instance
     */
    public AnnotatedElement getAnnotatedElement() {
        return annotatedElement;
    }

    /**
     * @return the annotation instance
     */
    public Annotation getAnnotation() {

        return annotation;
    }

    
    /**
     * @return the processing context
     */
    public ProcessingContext getProcessingContext() {
        return context;
    }
    
    /**
     * @return the annotated element ElementType
     */
    public ElementType getElementType() {
        return type;
    }
}
