/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.util.Map;
import java.lang.annotation.Annotation;

/**
 * This interface defines the result of an annotation processing 
 * returned by an annotation handler. Annotation handlers are supposed
 * to handle ONE annotation at a time. However, this simplistic 
 * approach does not always work as annotations on a element can have 
 * interdependencies. 
 *
 * This could be resolved trough sophisticated caching in the context
 * for instance but it is usually easier to notify the processor that 
 * a particular annotation handler has processed more than one annotation 
 * (which shouldn't be reprocessed subsequently...)
 *
 * @author Jerome Dochez
 */
public interface HandlerProcessingResult {
    
    /** 
     * Returns a map of annotation types processed by this handler as keys 
     * and a ResultType as a value to communicate the result of the annotation 
     * processing for each processed annotation types.
     * @return the map of processed annoation types and result.
     */
    public Map<Class<? extends Annotation>,ResultType> processedAnnotations();    
    
    /**
     * @return the overall result for this handler processing. Since handlers 
     * can process more than one annotation, this overall result will contain
     * the most severe error the haandler encountered while processing the
     * annotations.
     */
     public ResultType getOverallResult();
}
