/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.annotation.ErrorHandler;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;

import java.util.logging.Logger;
import java.util.logging.Level;

/**
 * Default implementation of the ErrorHandler
 *
 * @author Jerome Dochez
 */
public class DefaultErrorHandler implements ErrorHandler {
    
    Logger logger;

    /**
     * Creates a new ErrorHandler with the default logger
     */
    public DefaultErrorHandler() {
        logger = AnnotationUtils.getLogger();
    }
    
    /**
     * Creates a new ErrorHandler with the provided looger;
     */
    public DefaultErrorHandler(Logger logger){
        this.logger = logger;
    }

    /**
     * Receive notication of a fine error message
     * @param ape The warning information
     * @throws any exception to stop the annotation processing 
     */ 
    public void fine(AnnotationProcessorException ape) throws
            AnnotationProcessorException {
        
        if (logger.isLoggable(Level.FINE)){
            AnnotationInfo info = ape.getLocator();
            if (info==null){
                logger.fine(ape.getMessage());
            } else{
                logger.fine(AnnotationUtils.getLocalString(
                    "enterprise.deployment.annotation.error",
                    "{2}\n symbol: {0}\n location: {1}\n\n",
                    new Object[] { info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));            
            }
        }
        
    }
    
    /**
     * Receive notification of a warning
     * @param ape The warning information
     * @throws any exception to stop the annotation processing 
     */
    public void warning(AnnotationProcessorException ape) throws
            AnnotationProcessorException {
        
        if (logger.isLoggable(Level.WARNING)){
            AnnotationInfo info = ape.getLocator();
            if (info==null){
                logger.warning(ape.getMessage());
            } else{
                logger.warning(AnnotationUtils.getLocalString(
                    "enterprise.deployment.annotation.error",
                    "{2}\n symbol: {0}\n location: {1}\n\n",
                    new Object[] { info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));            
            }
        }
    }
    
    /**
     * Receive notification of an error
     * @param ape The error information
     * @throws amy exception to stop the annotation processing
     */
    public void error(AnnotationProcessorException ape) throws 
            AnnotationProcessorException {
        
        AnnotationInfo info = ape.getLocator();
        if (info==null){
            logger.severe(ape.getMessage());
        } else{
            logger.severe(AnnotationUtils.getLocalString(
                "enterprise.deployment.annotation.error",
                "{2}\n symbol: {0} location: {1}\n\n",
                new Object[] { info.getElementType(), info.getAnnotatedElement(), ape.getMessage()}));            
        }
    }
}
