/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.HashSet;
import java.net.URL;
import java.net.URLClassLoader;

import com.sun.enterprise.deployment.annotation.Scanner;

/**
 * Implementation of the Scanner interface for a directory
 *
 * @author Jerome Dochez
 */
public class DirectoryScanner extends JavaEEScanner implements Scanner {
    
    File directory;
    Set<String> entries = new HashSet<String>();
    ClassLoader classLoader = null;
    
    /** Creates a new instance of JarScanner */
    public DirectoryScanner(File directory) throws IOException {
        this(directory, null);
    }

    public DirectoryScanner(File directory, ClassLoader classLoader)
            throws IOException {
        AnnotationUtils.getLogger().finer("dir is " + directory);
        AnnotationUtils.getLogger().finer("classLoader is " + classLoader);
        this.directory = directory;
        this.classLoader = classLoader;
        init(directory);
    }       
    
    private void init(File directory) throws java.io.IOException {
        init(directory, directory);
    } 
    
    private void init(File top, File directory) throws java.io.IOException {
        
        File[] dirFiles = directory.listFiles(new FileFilter() {
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".class");
                }
        });
        for (File file : dirFiles) {
            entries.add(file.getPath().substring(top.getPath().length()+1));
        }
        
        File[] subDirs = directory.listFiles(new FileFilter() {
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
        });
        for (File subDir : subDirs) {
            init(top, subDir);
        }
    }
    
    protected Set<String> getEntries() {
        return entries;
    }

    public ClassLoader getClassLoader() {
        if (classLoader==null) {
            URL[] urls = new URL[1];
            try {
                urls[0] = directory.getAbsoluteFile().toURL();
                classLoader = new URLClassLoader(urls);
            } catch(Exception e) {
                e.printStackTrace();
            }
        }
        return classLoader;
    }

    public Set<Class> getElements() {
        
        
        Set<Class> elements = new HashSet<Class>();
        if (getClassLoader()==null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }        
        for (String fileName : entries) {
            // convert to a class name...
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length()-6);
            System.out.println("Getting " + className);
            try {                
                elements.add(classLoader.loadClass(className));
                
            } catch(Throwable cnfe) {
                AnnotationUtils.getLogger().severe("cannot load " + className + " reason : " + cnfe.getMessage());
            }
        }
        return elements;
    }
}
