/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * Provides the classes necessary to process J2SE 1.5 annotations in the context 
 * of the J2EE application server. 
 * 
 * <p>
 * Annotations are defined by their annotation type. This tool assumes that 
 * annotation handlers will be registered to it to process a particular annotation 
 * type. These annotation handlers have no particular knowledge outside of the 
 * annotation they process and the annoted element on which the annotation was
 * defined. 
 * </p>
 * <p>
 * The AnnotationProcessor tool implementation is responsible for maintening a 
 * list of annotations handlers per annotation type. AnnotationHandler are added
 * to the tool through the pushAnnotationHandler and can be removed through the 
 * popAnnotationHandler. Alternatively, the Factory singleton can be used to get
 * an initialized AnnotationProcessor with all the default AnnotationHandler. 
 * </p>
 * <p>
 * The tool uses the ProcessingContext to have access to Class instances. Each 
 * class instance will be processed in order, and if annotations are present, the 
 * tool will also process Field, Constructor and Methods elements. Each time the 
 * annotation processor switches for one particular AnnotatedElement to another,
 * it will send start and stop events to any AnnotatedElementHandler interface 
 * implementation registered within the ProcessingContext. This allow client 
 * code to keep context information about the AnnotatedElements being 
 * processed since AnnotationHandler only know about the AnnotatedElement the 
 * annotation was defined on.
 * </p>
 * @since 9.0
 * @auther Jerome Dochez
 */
package com.sun.enterprise.deployment.annotation;