/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.NMRServerConnection;
import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.Tie;
import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;

import java.util.logging.Level;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;

/**
 * Process a MEP for a new incoming message from NMR.
 * Processing always happen in a new thread. 
 *
 * @authod Binod PG.
 */
public class JAXWSMessageProcessor extends MessageProcessor {
    /**
     * MessageAcceptor uses this method to start processing the MEP.
     */
    public void process() {
        execute();
    }

    /**
     * Actual code that starts processing the MEP.
     */
    public void doWork() {
        try {
            // Add code here to process the received message.
            MessageExchange me = getMessageExchange();
            String endpoint = me.getEndpoint().getEndpointName();
            QName service = me.getEndpoint().getServiceName();
            NMRServerConnection connection = new NMRServerConnection(me);
            try {
                 debug(Level.FINEST,"serviceengine.process_incoming_request",
                        new Object[]{service.getLocalPart(), endpoint});   
                        
                 RuntimeEndpointInfo runtimeEndpointInfo = 
                    (RuntimeEndpointInfo)RuntimeEndpointInfoRegistryImpl.getInstance().
                    getRuntimeEndpointInfo(service, endpoint);
                 
                 // Call Tie.handle using WSRtObjectFactory
                 Tie tie = WSRtObjectFactory.newInstance().createTie();
                 tie.handle(connection,runtimeEndpointInfo);
                
                RuntimeEndpointInfoRegistryImpl.getInstance().releaseEndpoint(service, endpoint);
                 
                 debug(Level.FINEST,"serviceengine.success_incoming_request",
                        new Object[]{service.getLocalPart(), endpoint});   
                        
             } catch(Throwable e) {
                 logger.log(Level.SEVERE, "serviceengine.error_incoming_request", e);
                 
                 ServiceEngineException seException = new ServiceEngineException(e);
                 connection.handleException(seException);
             }
        } catch(Exception e) {
            logger.log(Level.SEVERE, "JavaEEServiceEngine : Error processing request" + e  , e);
        }
    }
    
    private void debug(Level logLevel, String msgID, Object[] params) {
        logger.log(logLevel, msgID, params);
    }
}

