/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;


import com.sun.xml.ws.spi.runtime.WSConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.MessageFactory;
/**
 *
 * @author Manisha Umbarje
 */
public abstract class NMRConnection implements WSConnection {

    Map<String, List<String>> headers = new HashMap<String, List<String>>();
    public OutputStream debugStream = null;
    public OutputStream outputStream = null;
    public InputStream inputStream = null;
    int statusCode;
    static String CONTENT_TYPE_HEADER = "Content-Type";
    static String XML_CONTENT_TYPE = "text/xml";
           
    public int getStatus () {
        return statusCode;
    }

    public void setStatus (int statusCode) {
        this.statusCode = statusCode;
    }

    public OutputStream getDebug () {
        return debugStream;
    }

    /**
     * @return outputStream
     * 
     * Returns the OutputStream on which the outbound message is written.
     * Any stream or connection initialization, pre-processing is done here.
     */
    public OutputStream getOutput() {
        outputStream = new ByteArrayOutputStream();
        
        return outputStream;
    }
    
    /**
     * @return inputStream
     *
     * Returns the InputStream on which the inbound message is received.
     * Any post-processing of message is done here.
     */
    public InputStream getInput() {
        
        // Receive Message 
        return inputStream;
    }

    public Map<String, List<String>> getHeaders () {
        return headers;
    }
    
    public void setHeaders (Map<String, List<String>> headers) {
        this.headers = headers;
    }

   
    protected void createSOAPMessageInputStream(SOAPMessage soapMessage) {
        if(soapMessage != null) {
            try {
                
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                soapMessage.writeTo(baos);
                inputStream = new ByteArrayInputStream(baos.toByteArray());
            } catch(Exception soapException) {
                soapException.printStackTrace();
                throw new TransportFailedException(soapException.getMessage());
            }
        }
    }
    
    protected SOAPMessage createSOAPMessageFromOutputStream(){
        ObjectInputStream objInputStream = null;
        try {
            
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
                byte[] message = ((ByteArrayOutputStream)outputStream).toByteArray();
                
                ByteArrayInputStream is = new ByteArrayInputStream(message);
                SOAPMessage soapMessage = MessageFactory.newInstance().createMessage(null,is);
                return soapMessage;
            }
        } catch(Exception e) {
            throw new TransportFailedException(e.getMessage());
        } finally {
            try {
                if(objInputStream != null)
                    objInputStream.close();
            } catch(Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;    
    } 
    
    protected void setContentType() {
       List<String> ctHeader = new ArrayList<String>();
       ctHeader.add(XML_CONTENT_TYPE);
       headers.put(CONTENT_TYPE_HEADER, ctHeader);
    }
    
    public void closeInput() {}
    public void closeOutput() {}
    public void close() {}
    
}
