/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageExchangeHelper;
import java.io.InputStream;
import javax.jbi.messaging.MessageExchange;
import javax.xml.soap.SOAPMessage;


/**
 *
 * @author Manisha Umbarje
 */
public class NMRServerConnection extends NMRConnection {
    
    private MessageExchangeHelper meHelper;
    
    /** Creates a new instance of NMRServerConnection */
    public NMRServerConnection(MessageExchange messageExchange) {
        meHelper = new MessageExchangeHelper();
        meHelper.setMessageExchange(messageExchange);
        setContentType();
        
    }
   
    public InputStream getInput () {
        try {
            SOAPMessage soapMessage = meHelper.denormalizeMessage(true);
            createSOAPMessageInputStream(soapMessage);
        } catch(Exception e) {
            throw new TransportFailedException(e.getMessage());
        }
        return inputStream;
    }

    public void closeOutput() {
        try {
            SOAPMessage incomingMessage = null;
            if(meHelper.isInOutMessageExchange()) {
                incomingMessage = createSOAPMessageFromOutputStream();
            } 
            meHelper.handleResponse(incomingMessage, false);
           
        } catch(Exception e) {
            throw new TransportFailedException(e.getMessage());
        }
    }
    
    public void handleException(Exception e) {
        meHelper.handleException(e);
    }
}
