/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineEndpoint {
    
    private String wsdlFilePath;
    private ServiceEndpoint jbiEndpoint;
    //private WebServiceEndpoint endpoint;
    private String url;
    private String sei;
    private String implClass;
    private boolean jaxwsFlag;
    private boolean ejbType;
    private boolean enabled ;
    private String contextRoot;
    private QName serviceName;
    private String endpointName;
    private ClassLoader classLoader;

    /** Creates a new instance of Endpoint */
    public ServiceEngineEndpoint(ServiceEndpoint jbiEndpoint, String wsdlFilePath,
            String sei, String implClass, String addressURI, String contextRoot, 
            boolean ejbType,
            boolean jaxwsFlag, boolean enabled, ClassLoader classLoader) {
        this(jbiEndpoint.getServiceName(), jbiEndpoint.getEndpointName(), 
                wsdlFilePath, sei, implClass, addressURI, contextRoot, ejbType,
                jaxwsFlag, enabled, classLoader);
        this.jbiEndpoint = jbiEndpoint;
    }
    
    public ServiceEngineEndpoint(QName serviceName, String endpointName, String wsdlFilePath,
            String sei, String implClass, String addressURI, String contextRoot, 
            boolean ejbType,
            boolean jaxwsFlag, boolean enabled, ClassLoader classLoader) {
        this.wsdlFilePath = wsdlFilePath;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.url = addressURI;
        this.ejbType = ejbType;
        this.sei = sei;
        this.implClass = implClass;
        this.jaxwsFlag = jaxwsFlag;
        this.enabled = enabled;
        this.contextRoot = contextRoot;    
        this.classLoader = classLoader;
    
    }
    
    public Document getServiceDescription() throws Exception {
        try {
            if (wsdlFilePath==null) {
                return null;
            }
            File wsdlFile = new File(wsdlFilePath);
            if (!wsdlFile.exists()) 
                return null;

            InputSource inputSource = 
                    new InputSource(new BufferedInputStream(
                    new FileInputStream(wsdlFile)));
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().
                    parse(new BufferedInputStream(
                    new FileInputStream(wsdlFile)));
        } catch(Exception e) {
            throw new Exception(e.getMessage());
        }
    }
    
    public String getServiceEndpointInterface() {
        return sei;
    }
    
    public String getURI() {
        return url;
    }
    
    public boolean isImplementedByEJB() {
        return ejbType;
    }
    
    public String getImplementationClass() {
        return implClass; 
    }
    
    public String getContextRoot() {
        return contextRoot;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return jbiEndpoint;
    }
    
    public void setServiceEndpoint(ServiceEndpoint jbiEp) {
        jbiEndpoint = jbiEp;
        setServiceName(jbiEp.getServiceName());
        setEndpointName(jbiEp.getEndpointName());
    }
    
    public QName getServiceName() {
        return serviceName;
    }
    
    public String getEndpointName() {
        return endpointName;
    }
    
    public boolean isEnabled() {
        return enabled;
    }
    
    public void setEnabled(boolean flag) {
        enabled = flag;
    }
    public boolean isJAXWSEndpoint() {
        return jaxwsFlag;
    }
    
    public ClassLoader getClassLoader() {
        return classLoader;
    }
    
    public String getWsdlPath() {
        return wsdlFilePath;
    }
    
    private void setServiceName(QName svcName) {
        serviceName = svcName;
    }
    
    private void setEndpointName(String epName) {
        endpointName = epName;
    }

}
