// Copyright (c) 2004-2005 Sun Microsystems Inc., All Rights Reserved.

/*
 * MessageDenormalizer.java
 *
 * SUN PROPRIETARY/CONFIDENTIAL.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import javax.jbi.messaging.Fault;
import javax.jbi.messaging.NormalizedMessage;


/**
 * This object is used by <code>MessageProcessor</code> implementations to
 * denormalize a JBI NormalizedMessage and convert it into a SOAP Message.
 * The object maps the Normalized Message's message content to SOAP:Body element in the
 * SOAP Message. The SOAP:header elements are extracted from a Normalized Message's
 * message context property "SoapHeader".
 *
 * @author Sun Microsystems, Inc.
 */
public interface MessageDenormalizer
{
    /**
     * Converts a normalized message to a SOAP Message.
     *
     * @param normalizedMessage message to be denormalized.
     * @param operation operation invoked
     * @param isResponse indicates if a response messages needs to be generated
     *
     * @return the SOAP Message.
     */
    SOAPWrapper denormalizeMessage(
        NormalizedMessage normalizedMessage, Operation operation, boolean isResponse);

    /**
     * Converts a fault mesage to a SOAP Message using the specified fault code.
     *
     * @param faultMessage fault message.
     *
     * @return a new SOAPWrapper instance which contains the SOAP fault Message.
     */
    SOAPWrapper denormalizeFaultMessage(Fault faultMessage);

    /**
     * Converts an exception to a SOAP Message. It uses the Server fault code in the soap
     * namespace.
     *
     * @param exception exception instance
     *
     * @return denormalized exception instance.
     */
    SOAPWrapper denormalizeMessage(Exception exception);

    /**
     * Converts an exception to a SOAP Message. It uses the faultCode passed. The code
     * expects the faultcode passed to be part of the soap namespace.
     *
     * @param exception exception instance
     * @param faultCode fault code
     *
     * @return denormalized exception instance.
     */
    SOAPWrapper denormalizeMessage(Exception exception, String faultCode);
}
