// Copyright (c) 2004-2005 Sun Microsystems Inc., All Rights Reserved.

/*
 * MessageNormalizer.java
 *
 * SUN PROPRIETARY/CONFIDENTIAL.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import javax.jbi.JBIException;
import javax.jbi.messaging.NormalizedMessage;


/**
 * This object is used by <code>MessageProcessor</code> implementations to normalize
 * SOAP Message into JBI Normalized Message. The object maps
 * the SOAP:Body element in the SOAP Message to the Normalized Message's message
 * content. The SOAP:header elements are mapped to a property in the Normalized Message
 * MessageContext.  Protocol specific data will not be normalized.
 *
 * @author Sun Microsystems, Inc.
 */
public interface MessageNormalizer
{
    /**
     * Converts a SOAP Message to a NormalizedMessage format.
     *
     * @param soapWrapper request message.
     * @param normalizedMessage jbi specific format.
     * @param operation operation requested.
     *
     * @throws JBIException when the message cannot be normalized.
     */
    void normalizeMessage(
        SOAPWrapper soapWrapper, NormalizedMessage normalizedMessage, Operation operation)
        throws JBIException;
}
