/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EnvironmentFactory.java
 *
 * Created on January 9, 2004, 11:42 AM
 */

package com.sun.enterprise.config.pluggable;

import com.sun.enterprise.config.ConfigRuntimeException;
import com.sun.enterprise.config.impl.ConfigEnvironmentImpl;
import com.sun.enterprise.config.impl.DefaultConfigBeanInterceptor;
import com.sun.enterprise.config.util.LocalStringsHelper;
import com.sun.enterprise.config.util.LoggerHelper;
/**
 * provides a implementation of factory. Users can
 * extend this class and implement required methods and set their
 * class in environment variable ENVIRONMENT_FACTORY_CLASS. The
 * statis create method in this class reads the variable and
 * instantiates the class. Note that the implemented factory
 * needs a no arg constructor
 * @author  sridatta
 */
public class EnvironmentFactory {
    
   static final String ENVIRONMENT_FACTORY_CLASS = 
      "com.sun.enterprise.config.config_environment_factory_class";
        
    private static EnvironmentFactory _ENV = null;
    
    /** Creates a new instance of EnvironmentFactory */
    public EnvironmentFactory() {
    }
    
    public static synchronized EnvironmentFactory getEnvironmentFactory() {
        if(_ENV == null) {
           _ENV = createEnvironmentFactory();
        } 
        return _ENV; 
    }
        
    private static EnvironmentFactory createEnvironmentFactory() {
                                            
        String factoryClassName = System.getProperty(ENVIRONMENT_FACTORY_CLASS);
        
        Class factoryClass;
        try {
            if(factoryClassName!= null && !"".equals(factoryClassName)) {
                factoryClass = Class.forName(factoryClassName);
            } else {
                factoryClass = EnvironmentFactory.class;
            }
        }catch(Exception e) {
            throw new ConfigRuntimeException(
                    "error_loading_environment_factory_class",
                    LocalStringsHelper.
                        getString("error_loading_environment_factory_class"),
                    e);
        }
        LoggerHelper.fine(
            "com.sun.enterprise.config.pluggable.EnvironmentFactory.getEnvironmentFactory():" +
                    "Factory Class is " + factoryClass);
        
        EnvironmentFactory result = null;
        try {
            result = (EnvironmentFactory) factoryClass.newInstance();
        } catch(Exception e) {
            throw new ConfigRuntimeException(
                "error_creating_environment_factory", 
                LocalStringsHelper.
                        getString("error_creating_environment_factory"),
                e);
        }
        
        return result;
    }
    
    /**
     * creates a new configEnvironmentImpl with 
     * defaults
     */
    public ConfigEnvironment getConfigEnvironment() {
        ConfigEnvironment ce = new ConfigEnvironmentImpl();
        ce.setConfigBeanInterceptor(new DefaultConfigBeanInterceptor());
        return ce;
    }
}
