/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.*;

/**
 * <!ELEMENT adminobject (adminobject-interface, adminobject-class, config-property*)>
 *
 * @author Qingqing Ouyang
 * @author Sheetal Vartak
 */
public class AdminObject extends Descriptor {
    
    private String theInterface;
    private String theClass;
    private Set configProperties;

    private boolean isDirty = false;

    public AdminObject () {
        this.configProperties = new OrderedSet();
    }
    
    public AdminObject (String theInterface, String theClass)
    {
        this.theInterface = theInterface;
        this.theClass = theClass;
        this.configProperties = new OrderedSet();
    }
    
    public String getAdminObjectInterface() 
    {
        return this.theInterface;
    }

    public void setAdminObjectInterface (String intf) {
	this.theInterface = intf;
    }

    public String getAdminObjectClass()
    {
        return this.theClass;
    }

    public void setAdminObjectClass (String cl) {
	this.theClass = cl;
    }

    /** 
     * Set of EnvironmentProperty 
     */
    public Set getConfigProperties() 
    {
        return configProperties;
    }
      
    /** 
     * Add a configProperty to the set
     */
    public void addConfigProperty(EnvironmentProperty configProperty) 
    {
	this.configProperties.add(configProperty);
	this.setDirty();
	this.changed();
    }

    /** 
     * Add a configProperty to the set
     */ 
    public void removeConfigProperty(EnvironmentProperty configProperty) 
    {
	this.configProperties.remove(configProperty);
	this.setDirty();
	this.changed();
    }

    public boolean isDirty() 
    {
	return this.isDirty;
    }
    
    public void changed() 
    {
	super.changed();
    }    

    private void setDirty() {
        this.isDirty = true;
    }
}
