/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.util.HashSet;

/** 
 * Holds namespace-to-package mapping information from a 
 * "non-exhaustive" jaxrpc mapping file.
 *
 * @author Kenneth Saks
 */
 
public class JaxrpcMappingDescriptor extends Descriptor {

    private Map packageToNamespaceUriMap = new HashMap();
    private Map namespaceUriToPackageMap = new HashMap();

    private boolean simpleMapping = true;

    public JaxrpcMappingDescriptor() {
    }

    public void setSpecVersion(String version) {
        // ignore
    }

    public void setIsSimpleMapping(boolean flag) {
        simpleMapping = flag;
    }

    /**
     * @return true if only mapping info only contains package->namespace
     * mapping.
     */
    public boolean isSimpleMapping() {
        return simpleMapping;
    }

    public void addMapping(String javaPackage, String namespaceUri) {
        packageToNamespaceUriMap.put(javaPackage, namespaceUri);
        namespaceUriToPackageMap.put(namespaceUri, javaPackage);
    }

    /**
     * @return Collection of Mapping elements
     */
    public Collection getMappings() {
        Collection mappings = new HashSet();
        for(Iterator nIter = namespaceUriToPackageMap.keySet().iterator(); 
            nIter.hasNext();) {
            String namespaceUri = (String) nIter.next();
            String javaPackage = (String) 
                namespaceUriToPackageMap.get(namespaceUri);
            Mapping mapping = new Mapping(namespaceUri, javaPackage);
            mappings.add(mapping);
        }
        return mappings;
    }

    public static class Mapping {
        private String namespaceUri;
        private String javaPackage;
        
        public Mapping(String namespace, String thePackage) {
            namespaceUri = namespace;
            javaPackage  = thePackage;
        }

        public String getNamespaceUri() {
            return namespaceUri;
        }

        public String getPackage() {
            return javaPackage;
        }
    }
    
}
