/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

    
/**
 * I am an object representing a dependency on a JMS Destination
 * (Queue/Topic)
 * @author Kenneth Saks
 */

import com.sun.enterprise.deployment.web.ContextParameter;

public interface JmsDestinationReference extends ContextParameter {

    /* Gets the logical name of the destination reference */
    public String getName();
    public void setName(String refName);

    /* Gets the type(javax.jms.Queue, javax.jms.Topic) of the destination */
    public String getType();
    public void setType(String refType);

}
