/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.security.Principal;

/**
 * This class implements the principal interface.
 *
 * @author Harish Prabandham
 */
public class PrincipalImpl implements Principal, java.io.Serializable {

    /**
     * @serial
     */
    private String name;

     /**
     * Construct a principal from a string user name.
     * @param user The string form of the principal name.
     */
    public PrincipalImpl(String user) {
	this.name = user;
    }

    /**
     * This function returns true if the object passed matches 
     * the principal represented in this implementation
     * @param another the Principal to compare with.
     * @return true if the Principal passed is the same as that 
     * encapsulated in this object, false otherwise
     */
    public boolean equals(Object another) {
        // XXX for bug 4889642: if groupA and userA have
        // the same name, then groupA.equals(userA) return false
        // BUT userA.equals(groupA) return "true"
        if (another instanceof Group) {
            return false;
        } else if (another instanceof PrincipalImpl) {
	    Principal p = (Principal) another;
	    return getName().equals(p.getName());
	} else
	    return false;
    }
    
    /**
     * Prints a stringified version of the principal.
     * @return A java.lang.String object returned by the method getName()
     */
    public String toString() {
	return getName();
    }

    /**
     * Returns the hashcode for this Principal object
     * @return a hashcode for the principal.
     */
    public int hashCode() {
	return name.hashCode();
    }

    /**
     * Gets the name of the Principal as a java.lang.String
     * @return the name of the principal.
     */
    public String getName() {
	return name;
    }

}
