/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

/**
 * In EJBs, ACL checking is done using the Roles. Roles are an abstraction
 * of an application specific Logical Principals. These Principals do not
 * have any properties of Principals within a Security Domain (or Realm).
 * They merely serve as abstraction to application specific entities.
 * @author Harish Prabandham
 */
public class Role extends PrincipalImpl {

    private String description;

    /** Creates a new Role with a given name */
    public Role(String name) {
	super(name);
    }

    
    public boolean equals(Object other) {
	boolean ret = false;
	if(other instanceof Role) {
	    ret =  getName().equals(((Role)other).getName());
	}
	
	return ret;
    }
    
    
    public String getDescription() {
	if (this.description == null) {
	    this.description = "";
	}
	return this.description;
    }
    
    public void setDescription(String description) {
	this.description = description;
    }
}

